/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.command.RegistryContext;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FireAllRulesCommand
implements ExecutableCommand<Integer>,
IdentifiableResult {
    @XmlAttribute
    private int max = -1;
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    @XmlAnyElement(lax=true)
    private AgendaFilter agendaFilter = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public FireAllRulesCommand() {
    }

    public FireAllRulesCommand(String outIdentifer) {
        this.outIdentifier = outIdentifer;
    }

    public FireAllRulesCommand(int max) {
        this.max = max;
    }

    public FireAllRulesCommand(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }

    public FireAllRulesCommand(AgendaFilter agendaFilter, int max) {
        this(agendaFilter);
        this.max = max;
    }

    public FireAllRulesCommand(String outIdentifier, int max, AgendaFilter agendaFilter) {
        this(agendaFilter, max);
        this.outIdentifier = outIdentifier;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public AgendaFilter getAgendaFilter() {
        return this.agendaFilter;
    }

    public void setAgendaFilter(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public Integer execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        int fired = this.max != -1 && this.agendaFilter != null ? ksession.fireAllRules(this.agendaFilter, this.max) : (this.max != -1 ? ksession.fireAllRules(this.max) : (this.agendaFilter != null ? ksession.fireAllRules(this.agendaFilter) : ksession.fireAllRules()));
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.outIdentifier, fired);
        }
        return fired;
    }

    public String toString() {
        if (this.max != -1 && this.agendaFilter != null) {
            return "session.fireAllRules( " + this.agendaFilter + ", " + this.max + " );";
        }
        if (this.max != -1) {
            return "session.fireAllRules( " + this.max + " );";
        }
        if (this.agendaFilter != null) {
            return "session.fireAllRules( " + this.agendaFilter + " );";
        }
        return "session.fireAllRules();";
    }
}

