/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetNode;

public class BavetNodeBuildPolicy<Solution_> {
    private final BavetConstraintSession<Solution_, ?> session;
    private final Map<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode> joinConstraintStreamToJoinBridgeNodeMap = new HashMap<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode>();
    private final Map<BavetAbstractNode, BavetAbstractNode> sharableNodeMap = new HashMap<BavetAbstractNode, BavetAbstractNode>();
    private int nextNodeIndex = 0;

    public BavetNodeBuildPolicy(BavetConstraintSession<Solution_, ?> session) {
        this.session = session;
    }

    public <Node_ extends BavetAbstractNode> Node_ retrieveSharedNode(Node_ node) {
        BavetAbstractNode sharedNode = this.sharableNodeMap.computeIfAbsent(node, k -> node);
        if (sharedNode != node) {
            this.nextNodeIndex = node.getNodeIndex();
        }
        return (Node_)sharedNode;
    }

    public BavetConstraintSession<Solution_, ?> getSession() {
        return this.session;
    }

    public int nextNodeIndex() {
        return this.nextNodeIndex++;
    }

    public Map<BavetJoinConstraintStream<Solution_>, BavetJoinBridgeNode> getJoinConstraintStreamToJoinBridgeNodeMap() {
        return this.joinConstraintStreamToJoinBridgeNodeMap;
    }

    public List<BavetNode> getCreatedNodes() {
        int expectedMaxNodeIndex;
        if (this.sharableNodeMap.isEmpty()) {
            return Collections.emptyList();
        }
        SortedMap nodeIndexToNodeMap = this.sharableNodeMap.keySet().stream().collect(Collectors.toMap(BavetAbstractNode::getNodeIndex, Function.identity(), (a, b) -> {
            throw new IllegalStateException("Impossible state: 2 nodes (" + a + ", " + b + ") share the same index (" + a.getNodeIndex() + ").");
        }, TreeMap::new));
        int maxNodeIndex = (Integer)nodeIndexToNodeMap.lastKey();
        if (maxNodeIndex != (expectedMaxNodeIndex = nodeIndexToNodeMap.size() - 1)) {
            throw new IllegalStateException("Impossible state: maximum node index (" + maxNodeIndex + ") does not match the expected maximum node index (" + expectedMaxNodeIndex + ").");
        }
        return new ArrayList<BavetNode>(nodeIndexToNodeMap.values());
    }
}

