/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinBridgeTuple;
import org.optaplanner.constraint.streams.bavet.common.index.BavetIndex;
import org.optaplanner.constraint.streams.bavet.common.index.BavetIndexKey;

public class BavetEqualsIndex<Tuple_ extends BavetJoinBridgeTuple>
extends BavetIndex<Tuple_> {
    private final Map<BavetIndexKey, Set<Tuple_>> map = new HashMap<BavetIndexKey, Set<Tuple_>>();

    @Override
    public void remove(Tuple_ tuple) {
        BavetIndexKey oldIndexKey = new BavetIndexKey(tuple.getIndexProperties());
        Set<Tuple_> tupleSet = this.map.get(oldIndexKey);
        boolean removed = tupleSet.remove(tuple);
        if (!removed) {
            throw new IllegalStateException("Impossible state: the fact (" + tuple.getFactsString() + ")'s tuple cannot be removed in the index from the tupleSet (" + tupleSet + ").");
        }
        if (tupleSet.isEmpty()) {
            this.map.remove(oldIndexKey);
        }
        tuple.setIndexProperties(null);
    }

    @Override
    public void put(Object[] indexProperties, Tuple_ tuple) {
        Set tupleSet = this.map.computeIfAbsent(new BavetIndexKey(indexProperties), k -> new LinkedHashSet());
        boolean added = tupleSet.add(tuple);
        if (!added) {
            throw new IllegalStateException("Impossible state: the fact (" + tuple.getFactsString() + ") with indexProperties (" + Arrays.toString(indexProperties) + ") was already added in the index to the tupleSet (" + tupleSet + ").");
        }
        tuple.setIndexProperties(indexProperties);
    }

    @Override
    public Set<Tuple_> get(Object[] indexProperties) {
        Set<Tuple_> tupleSet = this.map.get(new BavetIndexKey(indexProperties));
        if (tupleSet == null) {
            return Collections.emptySet();
        }
        return tupleSet;
    }
}

