/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.stream.Constraint;

public final class BendableLongScoreInliner
extends AbstractScoreInliner<BendableLongScore> {
    private final long[] hardScores;
    private final long[] softScores;

    BendableLongScoreInliner(Map<Constraint, BendableLongScore> constraintToWeightMap, boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintToWeightMap, constraintMatchEnabled);
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        BendableLongScore constraintWeight = (BendableLongScore)this.getConstraintWeight(constraint);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if (constraintWeight.getHardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            long levelWeight = constraintWeight.getHardOrSoftScore(singleLevel.intValue());
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                    long hardImpact = levelWeight * matchWeight;
                    int n = level;
                    this.hardScores[n] = this.hardScores[n] + hardImpact;
                    UndoScoreImpacter undoScoreImpact = () -> {
                        int n = level;
                        this.hardScores[n] = this.hardScores[n] - hardImpact;
                    };
                    if (!this.constraintMatchEnabled) {
                        return undoScoreImpact;
                    }
                    Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableLongScore.ofHard((int)this.hardScores.length, (int)this.softScores.length, (int)level, (long)hardImpact), (List)justificationsSupplier.get());
                    return () -> {
                        undoScoreImpact.run();
                        undoConstraintMatch.run();
                    };
                });
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                long softImpact = levelWeight * matchWeight;
                int n = level;
                this.softScores[n] = this.softScores[n] + softImpact;
                UndoScoreImpacter undoScoreImpact = () -> {
                    int n = level;
                    this.softScores[n] = this.softScores[n] - softImpact;
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableLongScore.ofSoft((int)this.hardScores.length, (int)this.softScores.length, (int)level, (long)softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            int i;
            long[] hardImpacts = new long[this.hardScores.length];
            long[] softImpacts = new long[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i) * matchWeight;
                int n = i;
                this.hardScores[n] = this.hardScores[n] + hardImpacts[i];
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i) * matchWeight;
                int n = i;
                this.softScores[n] = this.softScores[n] + softImpacts[i];
            }
            UndoScoreImpacter undoScoreImpact = () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    int n = i;
                    this.hardScores[n] = this.hardScores[n] - hardImpacts[i];
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    int n = i;
                    this.softScores[n] = this.softScores[n] - softImpacts[i];
                }
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, BendableLongScore.of((long[])hardImpacts, (long[])softImpacts), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public BendableLongScore extractScore(int initScore) {
        return BendableLongScore.ofUninitialized((int)initScore, (long[])Arrays.copyOf(this.hardScores, this.hardScores.length), (long[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableLongScore.class.getSimpleName() + " inliner";
    }
}

