/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.quad;

import java.util.Arrays;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.impl.score.stream.JoinerType;

public final class DefaultQuadJoiner<A, B, C, D>
extends AbstractJoiner<D>
implements QuadJoiner<A, B, C, D> {
    public static final QuadJoiner NONE = new DefaultQuadJoiner(new TriFunction[0], new JoinerType[0], new Function[0]);
    private final TriFunction<A, B, C, ?>[] leftMappings;

    public <Property_> DefaultQuadJoiner(TriFunction<A, B, C, Property_> leftMapping, JoinerType joinerType, Function<D, Property_> rightMapping) {
        super(rightMapping, joinerType);
        this.leftMappings = new TriFunction[]{leftMapping};
    }

    private <Property_> DefaultQuadJoiner(TriFunction<A, B, C, Property_>[] leftMappings, JoinerType[] joinerTypes, Function<D, Property_>[] rightMappings) {
        super(rightMappings, joinerTypes);
        this.leftMappings = leftMappings;
    }

    public DefaultQuadJoiner<A, B, C, D> and(QuadJoiner<A, B, C, D> otherJoiner) {
        DefaultQuadJoiner castJoiner = (DefaultQuadJoiner)otherJoiner;
        int joinerCount = this.getJoinerCount();
        int castJoinerCount = castJoiner.getJoinerCount();
        int newJoinerCount = joinerCount + castJoinerCount;
        JoinerType[] newJoinerTypes = Arrays.copyOf(this.joinerTypes, newJoinerCount);
        TriFunction<A, B, C, ?>[] newLeftMappings = Arrays.copyOf(this.leftMappings, newJoinerCount);
        Function[] newRightMappings = Arrays.copyOf(this.rightMappings, newJoinerCount);
        for (int i = 0; i < castJoiner.getJoinerCount(); ++i) {
            int newJoinerIndex = i + joinerCount;
            newJoinerTypes[newJoinerIndex] = castJoiner.getJoinerType(i);
            newLeftMappings[newJoinerIndex] = castJoiner.getLeftMapping(i);
            newRightMappings[newJoinerIndex] = castJoiner.getRightMapping(i);
        }
        return new DefaultQuadJoiner<A, B, C, D>(newLeftMappings, newJoinerTypes, newRightMappings);
    }

    public TriFunction<A, B, C, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    public boolean matches(A a, B b, C c, D d) {
        int joinerCount = this.getJoinerCount();
        for (int i = 0; i < joinerCount; ++i) {
            Object rightMapping;
            Object leftMapping;
            JoinerType joinerType = this.getJoinerType(i);
            if (joinerType.matches(leftMapping = this.getLeftMapping(i).apply(a, b, c), rightMapping = this.getRightMapping(i).apply(d))) continue;
            return false;
        }
        return true;
    }
}

