/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ConditionalTagInspector;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalOSMTagInspector;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.routing.profiles.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.EncodedValueOld;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PMap;
import com.graphhopper.util.Translation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlagEncoder
implements FlagEncoder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFlagEncoder.class);
    protected final List<String> restrictions = new ArrayList<String>(5);
    protected final Set<String> intendedValues = new HashSet<String>(5);
    protected final Set<String> restrictedValues = new HashSet<String>(5);
    protected final Set<String> ferries = new HashSet<String>(5);
    protected final Set<String> oneways = new HashSet<String>(5);
    protected final Set<String> absoluteBarriers = new HashSet<String>(5);
    protected final Set<String> potentialBarriers = new HashSet<String>(5);
    protected final int speedBits;
    protected final double speedFactor;
    protected double speedDefault;
    private final int maxTurnCosts;
    private long encoderBit;
    protected BooleanEncodedValue accessEnc;
    protected BooleanEncodedValue roundaboutEnc;
    protected DecimalEncodedValue speedEncoder;
    protected PMap properties;
    protected int maxPossibleSpeed;
    private long nodeBitMask;
    private long relBitMask;
    private EncodedValueOld turnCostEncoder;
    private long turnRestrictionBit;
    private boolean blockByDefault = true;
    private boolean blockFords = true;
    private boolean registered;
    protected EncodedValueLookup encodedValueLookup;
    protected static final double UNKNOWN_DURATION_FERRY_SPEED = 5.0;
    protected static final double SHORT_TRIP_FERRY_SPEED = 20.0;
    protected static final double LONG_TRIP_FERRY_SPEED = 30.0;
    private ConditionalTagInspector conditionalTagInspector;

    public AbstractFlagEncoder(PMap properties) {
        throw new RuntimeException("This method must be overridden in derived classes");
    }

    public AbstractFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    protected AbstractFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        this.maxTurnCosts = maxTurnCosts <= 0 ? 0 : maxTurnCosts;
        this.speedBits = speedBits;
        this.speedFactor = speedFactor;
        this.oneways.add("yes");
        this.oneways.add("true");
        this.oneways.add("1");
        this.oneways.add("-1");
        this.ferries.add("shuttle_train");
        this.ferries.add("ferry");
    }

    protected void init() {
        this.conditionalTagInspector = new ConditionalOSMTagInspector(DateRangeParser.createCalendar(), this.restrictions, this.restrictedValues, this.intendedValues);
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public void setBlockByDefault(boolean blockByDefault) {
        this.blockByDefault = blockByDefault;
    }

    public boolean isBlockFords() {
        return this.blockFords;
    }

    public void setBlockFords(boolean blockFords) {
        this.blockFords = blockFords;
    }

    public ConditionalTagInspector getConditionalTagInspector() {
        return this.conditionalTagInspector;
    }

    protected void setConditionalTagInspector(ConditionalTagInspector conditionalTagInspector) {
        this.conditionalTagInspector = conditionalTagInspector;
    }

    public int defineNodeBits(int index, int shift) {
        return shift;
    }

    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        this.accessEnc = new SimpleBooleanEncodedValue(EncodingManager.getKey(prefix, "access"), true);
        registerNewEncodedValue.add(this.accessEnc);
        this.roundaboutEnc = this.getBooleanEncodedValue("roundabout");
        this.encoderBit = 1L << index;
    }

    public int defineRelationBits(int index, int shift) {
        return shift;
    }

    public abstract long handleRelationTags(long var1, ReaderRelation var3);

    public abstract EncodingManager.Access getAccess(ReaderWay var1);

    public abstract IntsRef handleWayTags(IntsRef var1, ReaderWay var2, EncodingManager.Access var3, long var4);

    public long handleNodeTags(ReaderNode node) {
        if (node.hasTag("barrier", this.absoluteBarriers)) {
            return this.encoderBit;
        }
        if (node.hasTag("barrier", this.potentialBarriers)) {
            boolean locked = false;
            if (node.hasTag("locked", (Object)"yes")) {
                locked = true;
            }
            for (String res : this.restrictions) {
                if (!locked && node.hasTag(res, this.intendedValues)) {
                    return 0L;
                }
                if (!node.hasTag(res, this.restrictedValues)) continue;
                return this.encoderBit;
            }
            if (this.blockByDefault) {
                return this.encoderBit;
            }
        }
        if (this.blockFords && (node.hasTag("highway", (Object)"ford") || node.hasTag("ford", new String[0])) && !node.hasTag(this.restrictions, this.intendedValues) && !node.hasTag("ford", (Object)"no")) {
            return this.encoderBit;
        }
        return 0L;
    }

    @Override
    public InstructionAnnotation getAnnotation(IntsRef edgeFlags, Translation tr) {
        return InstructionAnnotation.EMPTY;
    }

    protected void flagsDefault(IntsRef edgeFlags, boolean forward, boolean backward) {
        if (forward) {
            this.speedEncoder.setDecimal(false, edgeFlags, this.speedDefault);
        }
        if (backward && this.speedEncoder.isStoreTwoDirections()) {
            this.speedEncoder.setDecimal(true, edgeFlags, this.speedDefault);
        }
        this.accessEnc.setBool(false, edgeFlags, forward);
        this.accessEnc.setBool(true, edgeFlags, backward);
    }

    @Override
    public double getMaxSpeed() {
        return this.maxPossibleSpeed;
    }

    protected double getMaxSpeed(ReaderWay way) {
        double backSpeed;
        double maxSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed"));
        double fwdSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed:forward"));
        if (fwdSpeed >= 0.0 && (maxSpeed < 0.0 || fwdSpeed < maxSpeed)) {
            maxSpeed = fwdSpeed;
        }
        if ((backSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed:backward"))) >= 0.0 && (maxSpeed < 0.0 || backSpeed < maxSpeed)) {
            maxSpeed = backSpeed;
        }
        return maxSpeed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + this.accessEnc.hashCode();
        hash = 61 * hash + this.toString().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFlagEncoder afe = (AbstractFlagEncoder)obj;
        return this.toString().equals(afe.toString()) && this.encoderBit == afe.encoderBit && this.accessEnc.equals(afe.accessEnc);
    }

    public static double parseSpeed(String str) {
        if (Helper.isEmpty((String)str)) {
            return -1.0;
        }
        if ("none".equals(str)) {
            return 150.0;
        }
        if (str.endsWith(":rural") || str.endsWith(":trunk")) {
            return 80.0;
        }
        if (str.endsWith(":urban")) {
            return 50.0;
        }
        if (str.equals("walk") || str.endsWith(":living_street")) {
            return 6.0;
        }
        try {
            int mpInteger = str.indexOf("mp");
            if (mpInteger > 0) {
                str = str.substring(0, mpInteger).trim();
                int val = Integer.parseInt(str);
                return (double)val * 1.609344;
            }
            int knotInteger = str.indexOf("knots");
            if (knotInteger > 0) {
                str = str.substring(0, knotInteger).trim();
                int val = Integer.parseInt(str);
                return (double)val * 1.852;
            }
            int kmInteger = str.indexOf("km");
            if (kmInteger > 0) {
                str = str.substring(0, kmInteger).trim();
            } else {
                kmInteger = str.indexOf("kph");
                if (kmInteger > 0) {
                    str = str.substring(0, kmInteger).trim();
                }
            }
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return -1.0;
        }
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
    }

    protected double getFerrySpeed(ReaderWay way) {
        long duration = 0L;
        try {
            duration = Long.parseLong(way.getTag("duration:seconds"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        double durationInHours = (double)duration / 60.0 / 60.0;
        Number estimatedLength = way.getTag("estimated_distance", null);
        if (durationInHours > 0.0) {
            try {
                if (estimatedLength != null) {
                    long firstId;
                    double estimatedLengthInKm = estimatedLength.doubleValue() / 1000.0;
                    double calculatedTripSpeed = estimatedLengthInKm / durationInHours / 1.4;
                    if (calculatedTripSpeed > 0.01) {
                        if (calculatedTripSpeed > this.getMaxSpeed()) {
                            return this.getMaxSpeed();
                        }
                        if ((double)Math.round(calculatedTripSpeed) < this.speedFactor / 2.0) {
                            return this.speedFactor / 2.0;
                        }
                        return Math.round(calculatedTripSpeed);
                    }
                    long lastId = way.getNodes().isEmpty() ? -1L : way.getNodes().get(way.getNodes().size() - 1);
                    long l = firstId = way.getNodes().isEmpty() ? -1L : way.getNodes().get(0);
                    if (firstId != lastId) {
                        logger.warn("Unrealistic long duration ignored in way with way ID=" + way.getId() + " : Duration tag value=" + way.getTag("duration") + " (=" + Math.round((double)duration / 60.0) + " minutes)");
                    }
                    durationInHours = 0.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (durationInHours == 0.0) {
            if (estimatedLength != null && estimatedLength.doubleValue() <= 300.0) {
                return this.speedFactor / 2.0;
            }
            return 5.0;
        }
        if (durationInHours > 1.0) {
            return 30.0;
        }
        return 20.0;
    }

    void setRelBitMask(int usedBits, int shift) {
        this.relBitMask = (1L << usedBits) - 1L;
        this.relBitMask <<= shift;
    }

    long getRelBitMask() {
        return this.relBitMask;
    }

    void setNodeBitMask(int usedBits, int shift) {
        this.nodeBitMask = (1L << usedBits) - 1L;
        this.nodeBitMask <<= shift;
    }

    long getNodeBitMask() {
        return this.nodeBitMask;
    }

    public int defineTurnBits(int index, int shift) {
        if (this.maxTurnCosts == 0) {
            return shift;
        }
        if (this.maxTurnCosts == 1) {
            this.turnRestrictionBit = 1L << shift;
            return shift + 1;
        }
        int turnBits = Helper.countBitValue((int)this.maxTurnCosts);
        this.turnCostEncoder = new EncodedValueOld("TurnCost", shift, turnBits, 1.0, 0L, this.maxTurnCosts){

            @Override
            public final long getValue(long flags) {
                flags &= this.mask;
                return flags >>>= (int)this.shift;
            }
        };
        return shift + turnBits;
    }

    @Override
    public boolean isTurnRestricted(long flags) {
        if (this.maxTurnCosts == 0) {
            return false;
        }
        if (this.maxTurnCosts == 1) {
            return (flags & this.turnRestrictionBit) != 0L;
        }
        return this.turnCostEncoder.getValue(flags) == (long)this.maxTurnCosts;
    }

    @Override
    public double getTurnCost(long flags) {
        if (this.maxTurnCosts == 0) {
            return 0.0;
        }
        if (this.maxTurnCosts == 1) {
            return (flags & this.turnRestrictionBit) == 0L ? 0.0 : Double.POSITIVE_INFINITY;
        }
        long cost = this.turnCostEncoder.getValue(flags);
        if (cost == (long)this.maxTurnCosts) {
            return Double.POSITIVE_INFINITY;
        }
        return cost;
    }

    @Override
    public long getTurnFlags(boolean restricted, double costs) {
        if (this.maxTurnCosts == 0) {
            return 0L;
        }
        if (this.maxTurnCosts == 1) {
            if (costs != 0.0) {
                throw new IllegalArgumentException("Only restrictions are supported");
            }
            return restricted ? this.turnRestrictionBit : 0L;
        }
        if (restricted) {
            if (costs != 0.0 || Double.isInfinite(costs)) {
                throw new IllegalArgumentException("Restricted turn can only have infinite costs (or use 0)");
            }
        } else if (costs >= (double)this.maxTurnCosts) {
            throw new IllegalArgumentException("Cost is too high. Or specify restricted == true");
        }
        if (costs < 0.0) {
            throw new IllegalArgumentException("Turn costs cannot be negative");
        }
        if (costs >= (double)this.maxTurnCosts || restricted) {
            costs = this.maxTurnCosts;
        }
        return this.turnCostEncoder.setValue(0L, (int)costs);
    }

    @Override
    public final DecimalEncodedValue getAverageSpeedEnc() {
        if (this.speedEncoder == null) {
            throw new NullPointerException("FlagEncoder " + this.toString() + " not yet initialized");
        }
        return this.speedEncoder;
    }

    @Override
    public final BooleanEncodedValue getAccessEnc() {
        if (this.accessEnc == null) {
            throw new NullPointerException("FlagEncoder " + this.toString() + " not yet initialized");
        }
        return this.accessEnc;
    }

    protected void setSpeed(boolean reverse, IntsRef edgeFlags, double speed) {
        if (speed < 0.0 || Double.isNaN(speed)) {
            throw new IllegalArgumentException("Speed cannot be negative or NaN: " + speed + ", flags:" + BitUtil.LITTLE.toBitString(edgeFlags));
        }
        if (speed < this.speedFactor / 2.0) {
            this.speedEncoder.setDecimal(reverse, edgeFlags, 0.0);
            this.accessEnc.setBool(reverse, edgeFlags, false);
            return;
        }
        if (speed > this.getMaxSpeed()) {
            speed = this.getMaxSpeed();
        }
        this.speedEncoder.setDecimal(reverse, edgeFlags, speed);
    }

    double getSpeed(IntsRef edgeFlags) {
        return this.getSpeed(false, edgeFlags);
    }

    double getSpeed(boolean reverse, IntsRef edgeFlags) {
        double speedVal = this.speedEncoder.getDecimal(reverse, edgeFlags);
        if (speedVal < 0.0) {
            throw new IllegalStateException("Speed was negative!? " + speedVal);
        }
        return speedVal;
    }

    protected double applyMaxSpeed(ReaderWay way, double speed) {
        double maxSpeed = this.getMaxSpeed(way);
        if (maxSpeed >= 0.0) {
            return maxSpeed * 0.9;
        }
        return speed;
    }

    protected String getPropertiesString() {
        return "speed_factor=" + this.speedFactor + "|speed_bits=" + this.speedBits + "|turn_costs=" + (this.maxTurnCosts > 0);
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        return this.encodedValueLookup.getEncodedValue(key, encodedValueType);
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.encodedValueLookup.getBooleanEncodedValue(key);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.encodedValueLookup.getIntEncodedValue(key);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.encodedValueLookup.getDecimalEncodedValue(key);
    }

    @Override
    public <T extends Enum> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> enumType) {
        return this.encodedValueLookup.getEnumEncodedValue(key, enumType);
    }

    public void setEncodedValueLookup(EncodedValueLookup encodedValueLookup) {
        this.encodedValueLookup = encodedValueLookup;
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (TurnWeighting.class.isAssignableFrom(feature)) {
            return this.maxTurnCosts > 0;
        }
        return false;
    }

    @Override
    public boolean hasEncodedValue(String key) {
        return this.encodedValueLookup.hasEncodedValue(key);
    }
}

