/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.RoadEnvironment;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class OSMRoadEnvironmentParser
implements TagParser {
    private final EnumEncodedValue<RoadEnvironment> roadEnvEnc = new EnumEncodedValue<RoadEnvironment>("road_environment", RoadEnvironment.class);

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.roadEnvEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, EncodingManager.Access access, long relationFlags) {
        RoadEnvironment roadEnvironment = RoadEnvironment.OTHER;
        if (access.isFerry()) {
            roadEnvironment = RoadEnvironment.FERRY;
        } else if (readerWay.hasTag("bridge", new String[0]) && !readerWay.hasTag("bridge", (Object)"no")) {
            roadEnvironment = RoadEnvironment.BRIDGE;
        } else if (readerWay.hasTag("tunnel", new String[0]) && !readerWay.hasTag("tunnel", (Object)"no")) {
            roadEnvironment = RoadEnvironment.TUNNEL;
        } else if (readerWay.hasTag("ford", new String[0]) || readerWay.hasTag("highway", (Object)"ford")) {
            roadEnvironment = RoadEnvironment.FORD;
        } else if (readerWay.hasTag("route", (Object)"shuttle_train")) {
            roadEnvironment = RoadEnvironment.SHUTTLE_TRAIN;
        } else if (readerWay.hasTag("highway", new String[0])) {
            roadEnvironment = RoadEnvironment.ROAD;
        }
        if (roadEnvironment != RoadEnvironment.OTHER) {
            this.roadEnvEnc.setEnum(false, edgeFlags, roadEnvironment);
        }
        return edgeFlags;
    }
}

