/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.optaplanner.core.api.domain.variable.AbstractVariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.AbstractNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.BasicVariableNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.ListVariableNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.Notifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.NotifiableRegistry;
import org.optaplanner.core.impl.domain.variable.listener.support.Notification;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.violation.ShadowVariablesAssert;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.Supply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public final class VariableListenerSupport<Solution_>
implements SupplyManager {
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final NotifiableRegistry<Solution_> notifiableRegistry;
    private final Map<Demand<?>, Supply> supplyMap;
    private boolean notificationQueuesAreEmpty;
    private int nextGlobalOrder = 0;

    VariableListenerSupport(InnerScoreDirector<Solution_, ?> scoreDirector, NotifiableRegistry<Solution_> notifiableRegistry, Map<Demand<?>, Supply> supplyMap) {
        this.scoreDirector = scoreDirector;
        this.notifiableRegistry = notifiableRegistry;
        this.supplyMap = supplyMap;
    }

    public static <Solution_> VariableListenerSupport<Solution_> create(InnerScoreDirector<Solution_, ?> scoreDirector) {
        return new VariableListenerSupport<Solution_>(scoreDirector, new NotifiableRegistry<Solution_>(scoreDirector.getSolutionDescriptor()), new LinkedHashMap());
    }

    public void linkVariableListeners() {
        this.notificationQueuesAreEmpty = true;
        this.scoreDirector.getSolutionDescriptor().getEntityDescriptors().stream().map(EntityDescriptor::getDeclaredShadowVariableDescriptors).flatMap(Collection::stream).filter(ShadowVariableDescriptor::hasVariableListener).sorted(Comparator.comparingInt(ShadowVariableDescriptor::getGlobalShadowOrder)).forEach(this::processShadowVariableDescriptor);
    }

    private void processShadowVariableDescriptor(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        AbstractVariableListener<Solution_, Object> variableListener = shadowVariableDescriptor.buildVariableListener(this.scoreDirector);
        if (variableListener instanceof Supply) {
            this.supplyMap.put(shadowVariableDescriptor.getProvidedDemand(), (Supply)((Object)variableListener));
        }
        int globalOrder = shadowVariableDescriptor.getGlobalShadowOrder();
        this.notifiableRegistry.registerNotifiable(shadowVariableDescriptor.getSourceVariableDescriptorList(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, globalOrder));
        this.nextGlobalOrder = globalOrder + 1;
    }

    @Override
    public <Supply_ extends Supply> Supply_ demand(Demand<Supply_> demand) {
        return (Supply_)this.supplyMap.computeIfAbsent(demand, this::createSupply);
    }

    private Supply createSupply(Demand<?> demand) {
        Object supply = demand.createExternalizedSupply(this);
        if (supply instanceof SourcedVariableListener) {
            SourcedVariableListener variableListener = (SourcedVariableListener)supply;
            if (this.scoreDirector.getWorkingSolution() != null) {
                variableListener.resetWorkingSolution(this.scoreDirector);
            }
            this.notifiableRegistry.registerNotifiable(variableListener.getSourceVariableDescriptor(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, this.nextGlobalOrder++));
        }
        return supply;
    }

    public void resetWorkingSolution() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.resetWorkingSolution();
        }
    }

    public void close() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.closeVariableListener();
        }
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityAdded(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityRemoved(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
    }

    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        Collection<VariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            BasicVariableNotification notification = Notification.variableChanged(entity);
            for (VariableListenerNotifiable<Solution_> notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
    }

    public void beforeElementAdded(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.elementAdded(entity, index);
            for (ListVariableListenerNotifiable<Solution_> notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterElementAdded(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
    }

    public void beforeElementRemoved(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.elementRemoved(entity, index);
            for (ListVariableListenerNotifiable<Solution_> notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterElementRemoved(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int index) {
    }

    public void beforeElementMoved(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.elementMoved(sourceEntity, sourceIndex, destinationEntity, destinationIndex);
            for (ListVariableListenerNotifiable<Solution_> notifiable : notifiables) {
                notifiable.addNotification(notification);
            }
        }
        this.notificationQueuesAreEmpty = false;
    }

    public void afterElementMoved(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
    }

    public void triggerVariableListenersInNotificationQueues() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.triggerAllNotifications();
        }
        this.notificationQueuesAreEmpty = true;
    }

    public String createShadowVariablesViolationMessage() {
        Object workingSolution = this.scoreDirector.getWorkingSolution();
        ShadowVariablesAssert snapshot = ShadowVariablesAssert.takeSnapshot(this.scoreDirector.getSolutionDescriptor(), workingSolution);
        this.forceTriggerAllVariableListeners(workingSolution);
        int SHADOW_VARIABLE_VIOLATION_DISPLAY_LIMIT = 3;
        return snapshot.createShadowVariablesViolationMessage(3L);
    }

    private void forceTriggerAllVariableListeners(Solution_ workingSolution) {
        this.scoreDirector.getSolutionDescriptor().visitAllEntities(workingSolution, this::simulateGenuineVariableChange);
        this.triggerVariableListenersInNotificationQueues();
    }

    private void simulateGenuineVariableChange(Object entity) {
        EntityDescriptor<Solution_> entityDescriptor = this.scoreDirector.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass());
        for (VariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            this.beforeVariableChanged(variableDescriptor, entity);
            this.afterVariableChanged(variableDescriptor, entity);
        }
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (" + this.notificationQueuesAreEmpty + ") so any shadow variables might be stale so score calculation is unreliable.\nMaybe a " + ScoreDirector.class.getSimpleName() + ".before*() method was called without calling " + ScoreDirector.class.getSimpleName() + ".triggerVariableListeners(), before calling " + ScoreDirector.class.getSimpleName() + ".calculateScore().");
        }
    }
}

