/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.CarFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.util.PMap;
import java.util.Set;

public class Car4WDFlagEncoder
extends CarFlagEncoder {
    public Car4WDFlagEncoder() {
        this(5, 5.0, 0);
    }

    public Car4WDFlagEncoder(PMap properties) {
        super(properties);
    }

    public Car4WDFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    public Car4WDFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.init();
        this.trackTypeSpeedMap.put("grade4", 5);
        this.trackTypeSpeedMap.put("grade5", 5);
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Set<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return EncodingManager.Access.FERRY;
                }
            }
            return EncodingManager.Access.CAN_SKIP;
        }
        if (!this.defaultSpeedMap.containsKey(highwayValue)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (!firstValue.isEmpty()) {
            if (this.restrictedValues.contains(firstValue) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                return EncodingManager.Access.CAN_SKIP;
            }
            if (this.intendedValues.contains(firstValue)) {
                return EncodingManager.Access.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    @Override
    public String toString() {
        return "car4wd";
    }
}

