/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Collections;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListAssignMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;

public class OriginalListChangeIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final SingletonInverseVariableSupply inverseVariableSupply;
    private final IndexVariableSupply indexVariableSupply;
    private final Iterator<Object> valueIterator;
    private final EntitySelector<Solution_> entitySelector;
    private Iterator<Object> destinationEntityIterator;
    private PrimitiveIterator.OfInt destinationIndexIterator;
    private Object upcomingSourceEntity;
    private Integer upcomingSourceIndex;
    private Object upcomingDestinationEntity;
    private Object upcomingValue;

    public OriginalListChangeIterator(ListVariableDescriptor<Solution_> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply, EntityIndependentValueSelector<Solution_> valueSelector, EntitySelector<Solution_> entitySelector) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.indexVariableSupply = indexVariableSupply;
        this.valueIterator = valueSelector.iterator();
        this.entitySelector = entitySelector;
        this.destinationEntityIterator = Collections.emptyIterator();
        this.destinationIndexIterator = IntStream.empty().iterator();
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        if (!this.destinationIndexIterator.hasNext()) {
            while (!this.destinationEntityIterator.hasNext()) {
                if (!this.valueIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                this.upcomingValue = this.valueIterator.next();
                this.upcomingSourceEntity = this.inverseVariableSupply.getInverseSingleton(this.upcomingValue);
                this.upcomingSourceIndex = this.indexVariableSupply.getIndex(this.upcomingValue);
                this.destinationEntityIterator = this.entitySelector.iterator();
            }
            this.upcomingDestinationEntity = this.destinationEntityIterator.next();
            this.destinationIndexIterator = this.listIndexIterator(this.upcomingDestinationEntity);
        }
        if (this.upcomingSourceEntity == null && this.upcomingSourceIndex == null) {
            return new ListAssignMove<Solution_>(this.listVariableDescriptor, this.upcomingValue, this.upcomingDestinationEntity, this.destinationIndexIterator.nextInt());
        }
        return new ListChangeMove<Solution_>(this.listVariableDescriptor, this.upcomingSourceEntity, this.upcomingSourceIndex, this.upcomingDestinationEntity, this.destinationIndexIterator.nextInt());
    }

    private PrimitiveIterator.OfInt listIndexIterator(Object entity) {
        return IntStream.rangeClosed(0, this.listVariableDescriptor.getListSize(entity)).iterator();
    }
}

