/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EnumEncodedValue;
import com.graphhopper.routing.profiles.IntEncodedValue;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import java.util.ArrayList;
import java.util.List;

class VirtualEdgeIterator
implements EdgeIterator,
CHEdgeIteratorState {
    private final List<EdgeIteratorState> edges;
    private int current;

    public VirtualEdgeIterator(int edgeCount) {
        this.edges = new ArrayList<EdgeIteratorState>(edgeCount);
        this.reset();
    }

    void add(EdgeIteratorState edge) {
        this.edges.add(edge);
    }

    EdgeIterator reset() {
        this.current = -1;
        return this;
    }

    int count() {
        return this.edges.size();
    }

    @Override
    public boolean next() {
        ++this.current;
        return this.current < this.edges.size();
    }

    @Override
    public EdgeIteratorState detach(boolean reverse) {
        if (reverse) {
            throw new IllegalStateException("Not yet supported");
        }
        return this.edges.get(this.current);
    }

    @Override
    public int getEdge() {
        return this.edges.get(this.current).getEdge();
    }

    @Override
    public int getBaseNode() {
        return this.edges.get(this.current).getBaseNode();
    }

    @Override
    public int getAdjNode() {
        return this.edges.get(this.current).getAdjNode();
    }

    @Override
    public PointList fetchWayGeometry(int mode) {
        return this.edges.get(this.current).fetchWayGeometry(mode);
    }

    @Override
    public EdgeIteratorState setWayGeometry(PointList list) {
        return this.edges.get(this.current).setWayGeometry(list);
    }

    @Override
    public double getDistance() {
        return this.edges.get(this.current).getDistance();
    }

    @Override
    public EdgeIteratorState setDistance(double dist) {
        return this.edges.get(this.current).setDistance(dist);
    }

    @Override
    public IntsRef getFlags() {
        return this.edges.get(this.current).getFlags();
    }

    @Override
    public EdgeIteratorState setFlags(IntsRef flags) {
        return this.edges.get(this.current).setFlags(flags);
    }

    @Override
    public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
        this.edges.get(this.current).set(property, value);
        return this;
    }

    @Override
    public boolean get(BooleanEncodedValue property) {
        return this.edges.get(this.current).get(property);
    }

    @Override
    public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
        this.edges.get(this.current).setReverse(property, value);
        return this;
    }

    @Override
    public boolean getReverse(BooleanEncodedValue property) {
        return this.edges.get(this.current).getReverse(property);
    }

    @Override
    public EdgeIteratorState set(IntEncodedValue property, int value) {
        this.edges.get(this.current).set(property, value);
        return this;
    }

    @Override
    public int get(IntEncodedValue property) {
        return this.edges.get(this.current).get(property);
    }

    @Override
    public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
        this.edges.get(this.current).setReverse(property, value);
        return this;
    }

    @Override
    public int getReverse(IntEncodedValue property) {
        return this.edges.get(this.current).getReverse(property);
    }

    @Override
    public EdgeIteratorState set(DecimalEncodedValue property, double value) {
        this.edges.get(this.current).set(property, value);
        return this;
    }

    @Override
    public double get(DecimalEncodedValue property) {
        return this.edges.get(this.current).get(property);
    }

    @Override
    public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
        this.edges.get(this.current).setReverse(property, value);
        return this;
    }

    @Override
    public double getReverse(DecimalEncodedValue property) {
        return this.edges.get(this.current).getReverse(property);
    }

    @Override
    public <T extends Enum> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
        this.edges.get(this.current).set(property, value);
        return this;
    }

    @Override
    public <T extends Enum> T get(EnumEncodedValue<T> property) {
        return this.edges.get(this.current).get(property);
    }

    @Override
    public <T extends Enum> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
        this.edges.get(this.current).setReverse(property, value);
        return this;
    }

    @Override
    public <T extends Enum> T getReverse(EnumEncodedValue<T> property) {
        return this.edges.get(this.current).getReverse(property);
    }

    @Override
    public String getName() {
        return this.edges.get(this.current).getName();
    }

    @Override
    public EdgeIteratorState setName(String name) {
        return this.edges.get(this.current).setName(name);
    }

    public String toString() {
        if (this.current >= 0 && this.current < this.edges.size()) {
            return "virtual edge: " + this.edges.get(this.current) + ", all: " + this.edges.toString();
        }
        return "virtual edge: (invalid), all: " + this.edges.toString();
    }

    @Override
    public int getAdditionalField() {
        return this.edges.get(this.current).getAdditionalField();
    }

    @Override
    public EdgeIteratorState setAdditionalField(int value) {
        return this.edges.get(this.current).setAdditionalField(value);
    }

    @Override
    public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState edge) {
        return this.edges.get(this.current).copyPropertiesFrom(edge);
    }

    @Override
    public boolean isShortcut() {
        EdgeIteratorState edge = this.edges.get(this.current);
        return edge instanceof CHEdgeIteratorState && ((CHEdgeIteratorState)edge).isShortcut();
    }

    @Override
    public double getWeight() {
        return ((CHEdgeIteratorState)this.edges.get(this.current)).getWeight();
    }

    @Override
    public CHEdgeIteratorState setWeight(double weight) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setFlagsAndWeight(int flags, double weight) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getSkippedEdge1() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getSkippedEdge2() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public CHEdgeIteratorState setSkippedEdges(int edge1, int edge2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public CHEdgeIteratorState setFirstAndLastOrigEdges(int firstOrigEdge, int lastOrigEdge) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getOrigEdgeFirst() {
        return this.edges.get(this.current).getOrigEdgeFirst();
    }

    @Override
    public int getOrigEdgeLast() {
        return this.edges.get(this.current).getOrigEdgeLast();
    }

    @Override
    public int getMergeStatus(int flags) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

