/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Arrays;

public class LMApproximator
implements WeightApproximator {
    private final LandmarkStorage lms;
    private int[] activeLandmarks;
    private int[] activeFromIntWeights;
    private int[] activeToIntWeights;
    private double epsilon = 1.0;
    private int to = -1;
    private boolean doALMRecalc = true;
    private final double factor;
    private final boolean reverse;
    private final int maxBaseNodes;
    private final Graph graph;
    private final WeightApproximator fallBackApproximation;
    private boolean fallback = false;
    private final GHIntObjectHashMap<VirtEntry> virtNodeMap;

    public LMApproximator(Graph graph, int maxBaseNodes, LandmarkStorage lms, int activeCount, double factor, boolean reverse) {
        int idxVirtNode;
        this.reverse = reverse;
        this.lms = lms;
        this.factor = factor;
        if (activeCount > lms.getLandmarkCount()) {
            throw new IllegalArgumentException("Active landmarks " + activeCount + " should be lower or equals to landmark count " + lms.getLandmarkCount());
        }
        this.activeLandmarks = new int[activeCount];
        Arrays.fill(this.activeLandmarks, -1);
        this.activeFromIntWeights = new int[activeCount];
        this.activeToIntWeights = new int[activeCount];
        this.graph = graph;
        this.fallBackApproximation = new BeelineWeightApproximator(graph.getNodeAccess(), lms.getWeighting());
        this.maxBaseNodes = maxBaseNodes;
        this.virtNodeMap = new GHIntObjectHashMap(graph.getNodes() - idxVirtNode, 0.5);
        if (graph instanceof QueryGraph) {
            QueryGraph qGraph = (QueryGraph)graph;
            for (idxVirtNode = maxBaseNodes; idxVirtNode < qGraph.getNodes(); ++idxVirtNode) {
                EdgeIteratorState edge = qGraph.getOriginalEdgeFromVirtNode(idxVirtNode);
                int weight = lms.calcWeight(edge, reverse);
                int reverseWeight = lms.calcWeight(edge, !reverse);
                VirtEntry virtEntry = new VirtEntry();
                if (weight < Integer.MAX_VALUE && (reverseWeight >= Integer.MAX_VALUE || weight < reverseWeight)) {
                    virtEntry.weight = weight;
                    virtEntry.node = reverse ? edge.getBaseNode() : edge.getAdjNode();
                } else {
                    virtEntry.weight = reverseWeight;
                    if (reverseWeight >= Integer.MAX_VALUE) {
                        throw new IllegalStateException("At least one direction of edge (" + edge + ") should be accessible but wasn't!");
                    }
                    virtEntry.node = reverse ? edge.getAdjNode() : edge.getBaseNode();
                }
                this.virtNodeMap.put(idxVirtNode, virtEntry);
            }
        }
    }

    public LMApproximator setEpsilon(double epsilon) {
        this.epsilon = epsilon;
        return this;
    }

    @Override
    public double approximate(int queryNode) {
        int maxWeightInt;
        if (!this.doALMRecalc && this.fallback || this.lms.isEmpty()) {
            return this.fallBackApproximation.approximate(queryNode);
        }
        int node = queryNode;
        int virtEdgeWeightInt = 0;
        if (queryNode >= this.maxBaseNodes) {
            VirtEntry virtEntry = (VirtEntry)this.virtNodeMap.get(queryNode);
            node = virtEntry.node;
            virtEdgeWeightInt = virtEntry.weight;
        }
        if (node == this.to) {
            return 0.0;
        }
        if (this.doALMRecalc) {
            this.doALMRecalc = false;
            boolean res = this.lms.initActiveLandmarks(node, this.to, this.activeLandmarks, this.activeFromIntWeights, this.activeToIntWeights, this.reverse);
            if (!res) {
                this.fallback = true;
                return this.fallBackApproximation.approximate(queryNode);
            }
        }
        if ((maxWeightInt = this.getMaxWeight(node, virtEdgeWeightInt, this.activeLandmarks, this.activeFromIntWeights, this.activeToIntWeights)) < 0) {
            return 0.0;
        }
        return (double)maxWeightInt * this.factor * this.epsilon;
    }

    int getMaxWeight(int node, int virtEdgeWeightInt, int[] activeLandmarks, int[] activeFromIntWeights, int[] activeToIntWeights) {
        int maxWeightInt = -1;
        for (int activeLMIdx = 0; activeLMIdx < activeLandmarks.length; ++activeLMIdx) {
            int landmarkIndex = activeLandmarks[activeLMIdx];
            int fromWeightInt = activeFromIntWeights[activeLMIdx] - (this.lms.getFromWeight(landmarkIndex, node) + virtEdgeWeightInt);
            int toWeightInt = this.lms.getToWeight(landmarkIndex, node) - activeToIntWeights[activeLMIdx];
            if (this.reverse) {
                fromWeightInt = -fromWeightInt;
                toWeightInt = -toWeightInt - virtEdgeWeightInt;
            } else {
                toWeightInt -= virtEdgeWeightInt;
            }
            int tmpMaxWeightInt = Math.max(fromWeightInt, toWeightInt);
            if (tmpMaxWeightInt <= maxWeightInt) continue;
            maxWeightInt = tmpMaxWeightInt;
        }
        return maxWeightInt;
    }

    final int getNode(int node) {
        return node >= this.maxBaseNodes ? ((VirtEntry)this.virtNodeMap.get(node)).node : node;
    }

    @Override
    public void setTo(int to) {
        this.to = this.getNode(to);
    }

    @Override
    public WeightApproximator reverse() {
        return new LMApproximator(this.graph, this.maxBaseNodes, this.lms, this.activeLandmarks.length, this.factor, !this.reverse);
    }

    public void triggerActiveLandmarkRecalculation() {
        this.doALMRecalc = true;
    }

    public String toString() {
        return "landmarks";
    }

    private static class VirtEntry {
        private int node;
        private int weight;

        private VirtEntry() {
        }

        public String toString() {
            return this.node + ", " + this.weight;
        }
    }
}

