/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.weighting.WeightApproximator;

public class ConsistentWeightApproximator {
    private final WeightApproximator uniDirApproximatorForward;
    private final WeightApproximator uniDirApproximatorReverse;

    public ConsistentWeightApproximator(WeightApproximator weightApprox) {
        if (weightApprox == null) {
            throw new IllegalArgumentException("WeightApproximator cannot be null");
        }
        this.uniDirApproximatorForward = weightApprox;
        this.uniDirApproximatorReverse = weightApprox.reverse();
    }

    public WeightApproximator getApproximation() {
        return this.uniDirApproximatorForward;
    }

    public void setFrom(int from) {
        this.uniDirApproximatorReverse.setTo(from);
    }

    public void setTo(int to) {
        this.uniDirApproximatorForward.setTo(to);
    }

    public double approximate(int node, boolean reverse) {
        double weightApproximation = 0.5 * (this.uniDirApproximatorForward.approximate(node) - this.uniDirApproximatorReverse.approximate(node));
        if (reverse) {
            return -weightApproximation;
        }
        return weightApproximation;
    }

    public String toString() {
        return this.uniDirApproximatorForward.toString();
    }
}

