/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.coll.MapEntry;
import com.graphhopper.routing.profiles.Country;
import com.graphhopper.routing.profiles.RoadAccess;
import com.graphhopper.routing.profiles.RoadClass;
import com.graphhopper.routing.profiles.RoadEnvironment;
import com.graphhopper.routing.profiles.Surface;
import com.graphhopper.routing.profiles.Toll;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.details.DecimalDetails;
import com.graphhopper.util.details.DistanceDetails;
import com.graphhopper.util.details.EdgeIdDetails;
import com.graphhopper.util.details.EnumDetails;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.StreetNameDetails;
import com.graphhopper.util.details.TimeDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PathDetailsBuilderFactory {
    public List<PathDetailsBuilder> createPathDetailsBuilders(List<String> requestedPathDetails, FlagEncoder encoder, Weighting weighting) {
        ArrayList<PathDetailsBuilder> builders = new ArrayList<PathDetailsBuilder>();
        if (requestedPathDetails.contains("average_speed")) {
            builders.add(new DecimalDetails("average_speed", encoder.getAverageSpeedEnc()));
        }
        if (requestedPathDetails.contains("street_name")) {
            builders.add(new StreetNameDetails());
        }
        if (requestedPathDetails.contains("edge_id")) {
            builders.add(new EdgeIdDetails());
        }
        if (requestedPathDetails.contains("time")) {
            builders.add(new TimeDetails(weighting));
        }
        if (requestedPathDetails.contains("distance")) {
            builders.add(new DistanceDetails());
        }
        for (String string : Arrays.asList("max_speed", "max_width", "max_height", "max_weight")) {
            if (!requestedPathDetails.contains(string) || !encoder.hasEncodedValue(string)) continue;
            builders.add(new DecimalDetails(string, encoder.getDecimalEncodedValue(string)));
        }
        for (Map.Entry entry : Arrays.asList(new MapEntry<String, Class<RoadClass>>("road_class", RoadClass.class), new MapEntry<String, Class<RoadEnvironment>>("road_environment", RoadEnvironment.class), new MapEntry<String, Class<Surface>>("surface", Surface.class), new MapEntry<String, Class<RoadAccess>>("road_access", RoadAccess.class), new MapEntry<String, Class<Toll>>("toll", Toll.class), new MapEntry<String, Class<Country>>("country", Country.class))) {
            String key = (String)entry.getKey();
            if (!requestedPathDetails.contains(key) || !encoder.hasEncodedValue(key)) continue;
            builders.add(new EnumDetails(key, encoder.getEnumEncodedValue(key, (Class)entry.getValue())));
        }
        if (requestedPathDetails.size() != builders.size()) {
            throw new IllegalArgumentException("You requested the details " + requestedPathDetails + " but we could only find " + builders);
        }
        return builders;
    }
}

