/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.Path;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.PathDetailsBuilder;
import java.util.List;

public class PathDetailsFromEdges
implements Path.EdgeVisitor {
    private final List<PathDetailsBuilder> calculators;
    private int lastIndex = 0;

    public PathDetailsFromEdges(List<PathDetailsBuilder> calculators, int previousIndex) {
        this.calculators = calculators;
        this.lastIndex = previousIndex;
    }

    @Override
    public void next(EdgeIteratorState edge, int index, int prevEdgeId) {
        for (PathDetailsBuilder calc : this.calculators) {
            if (!calc.isEdgeDifferentToLastEdge(edge)) continue;
            calc.endInterval(this.lastIndex);
            calc.startInterval(this.lastIndex);
        }
        this.lastIndex += edge.fetchWayGeometry(2).size();
    }

    @Override
    public void finish() {
        for (PathDetailsBuilder calc : this.calculators) {
            calc.endInterval(this.lastIndex);
        }
    }
}

