/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.AbstractInserter;
import org.optaplanner.constraint.streams.bavet.common.AbstractUpdater;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetFilterBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B> {
    private final BavetAbstractBiConstraintStream<Solution_, A, B> parent;
    private final BiPredicate<A, B> predicate;

    public BavetFilterBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BiPredicate<A, B> predicate) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.predicate = predicate;
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate (null) cannot be null.");
        }
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, this.childStreamList, insert -> new ConditionalBiInserter<A, B>(this.predicate, insert), (update, retract) -> new ConditionalBiUpdater<A, B>(this.predicate, update, retract));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parent, this.predicate});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterBiConstraintStream) {
            BavetFilterBiConstraintStream other = (BavetFilterBiConstraintStream)((Object)o);
            return this.parent == other.parent && this.predicate == other.predicate;
        }
        return false;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }

    private static final class ConditionalBiUpdater<A, B>
    extends AbstractUpdater<BiTuple<A, B>> {
        private final BiPredicate<A, B> predicate;

        public ConditionalBiUpdater(BiPredicate<A, B> predicate, Consumer<BiTuple<A, B>> update, Consumer<BiTuple<A, B>> retract) {
            super(update, retract);
            this.predicate = predicate;
        }

        @Override
        protected boolean test(BiTuple<A, B> tuple) {
            return this.predicate.test(tuple.factA, tuple.factB);
        }
    }

    private static final class ConditionalBiInserter<A, B>
    extends AbstractInserter<BiTuple<A, B>> {
        private final BiPredicate<A, B> predicate;

        public ConditionalBiInserter(BiPredicate<A, B> predicate, Consumer<BiTuple<A, B>> insert) {
            super(insert);
            this.predicate = predicate;
        }

        @Override
        protected boolean test(BiTuple<A, B> tuple) {
            return this.predicate.test(tuple.factA, tuple.factB);
        }
    }
}

