/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple>
extends AbstractNode {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeft;
    private final int inputStoreIndexRight;
    private final Consumer<OutTuple_> nextNodesInsert;
    private final Consumer<OutTuple_> nextNodesUpdate;
    private final Consumer<OutTuple_> nextNodesRetract;
    private final Indexer<LeftTuple_, Map<UniTuple<Right_>, OutTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>, Map<LeftTuple_, OutTuple_>> indexerRight;
    private final Queue<OutTuple_> dirtyTupleQueue;

    protected AbstractJoinNode(Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeft, int inputStoreIndexRight, Consumer<OutTuple_> nextNodesInsert, Consumer<OutTuple_> nextNodesUpdate, Consumer<OutTuple_> nextNodesRetract, Indexer<LeftTuple_, Map<UniTuple<Right_>, OutTuple_>> indexerLeft, Indexer<UniTuple<Right_>, Map<LeftTuple_, OutTuple_>> indexerRight) {
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeft = inputStoreIndexLeft;
        this.inputStoreIndexRight = inputStoreIndexRight;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesUpdate = nextNodesUpdate;
        this.nextNodesRetract = nextNodesRetract;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
        this.dirtyTupleQueue = new ArrayDeque<OutTuple_>(1000);
    }

    public final void insertLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        if (tupleStore[this.inputStoreIndexLeft] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexProperties(leftTuple);
        tupleStore[this.inputStoreIndexLeft] = indexProperties;
        HashMap outTupleMapLeft = new HashMap();
        this.indexLeftTuple(leftTuple, indexProperties, outTupleMapLeft);
    }

    private void indexLeftTuple(LeftTuple_ leftTuple, IndexProperties newIndexProperties, Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft) {
        this.indexerLeft.put(newIndexProperties, leftTuple, outTupleMapLeft);
        this.indexerRight.visit(newIndexProperties, (rightTuple, emptyMap) -> {
            OutTuple_ outTuple = this.createOutTuple(leftTuple, (UniTuple<Right_>)rightTuple);
            outTuple.setState(BavetTupleState.CREATING);
            outTupleMapLeft.put((UniTuple<Right_>)rightTuple, outTuple);
            this.dirtyTupleQueue.add(outTuple);
        });
    }

    public void updateLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        IndexProperties oldIndexProperties = (IndexProperties)tupleStore[this.inputStoreIndexLeft];
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexProperties(leftTuple);
        if (oldIndexProperties.equals(newIndexProperties)) {
            Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft = this.indexerLeft.get(oldIndexProperties, leftTuple);
            for (Tuple outTuple : outTupleMapLeft.values()) {
                this.updateTuple(outTuple);
            }
        } else {
            Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft = this.indexerLeft.remove(oldIndexProperties, leftTuple);
            for (Tuple outTuple : outTupleMapLeft.values()) {
                this.retractTuple(outTuple);
            }
            outTupleMapLeft.clear();
            tupleStore[this.inputStoreIndexLeft] = newIndexProperties;
            this.indexLeftTuple(leftTuple, newIndexProperties, outTupleMapLeft);
        }
    }

    public final void retractLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        IndexProperties indexProperties = (IndexProperties)tupleStore[this.inputStoreIndexLeft];
        if (indexProperties == null) {
            return;
        }
        tupleStore[this.inputStoreIndexLeft] = null;
        Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft = this.indexerLeft.remove(indexProperties, leftTuple);
        for (Tuple outTuple : outTupleMapLeft.values()) {
            this.retractTuple(outTuple);
        }
    }

    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.store[this.inputStoreIndexRight] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.factA);
        rightTuple.store[this.inputStoreIndexRight] = indexProperties;
        this.indexRightTuple(rightTuple, indexProperties);
    }

    private void indexRightTuple(UniTuple<Right_> rightTuple, IndexProperties indexProperties) {
        this.indexerRight.put(indexProperties, rightTuple, Collections.emptyMap());
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> {
            OutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
            outTuple.setState(BavetTupleState.CREATING);
            outTupleMapLeft.put(rightTuple, outTuple);
            this.dirtyTupleQueue.add(outTuple);
        });
    }

    public void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.store[this.inputStoreIndexRight];
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.factA);
        if (oldIndexProperties.equals(newIndexProperties)) {
            this.indexerLeft.visit(oldIndexProperties, (leftTuple, outTupleMapLeft) -> {
                Tuple outTuple = (Tuple)outTupleMapLeft.get(rightTuple);
                if (outTuple == null) {
                    throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + oldIndexProperties + ") has tuples on the right side that didn't exist on the left side.");
                }
                this.updateTuple(outTuple);
            });
        } else {
            this.deindexRightTuple(oldIndexProperties, rightTuple);
            rightTuple.store[this.inputStoreIndexRight] = newIndexProperties;
            this.indexRightTuple(rightTuple, newIndexProperties);
        }
    }

    private void deindexRightTuple(IndexProperties indexProperties, UniTuple<Right_> rightTuple) {
        this.indexerRight.remove(indexProperties, rightTuple);
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> {
            Tuple outTuple = (Tuple)outTupleMapLeft.remove(rightTuple);
            if (outTuple == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + indexProperties + ") has tuples on the right side that didn't exist on the left side.");
            }
            this.retractTuple(outTuple);
        });
    }

    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.store[this.inputStoreIndexRight];
        if (indexProperties == null) {
            return;
        }
        rightTuple.store[this.inputStoreIndexRight] = null;
        this.deindexRightTuple(indexProperties, rightTuple);
    }

    protected abstract IndexProperties createIndexProperties(LeftTuple_ var1);

    protected abstract OutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    private void updateTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.UPDATING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    private void retractTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: {
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.DYING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            case UPDATING: {
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    @Override
    public void calculateScore() {
        block7: for (Tuple tuple : this.dirtyTupleQueue) {
            switch (tuple.getState()) {
                case CREATING: {
                    this.nextNodesInsert.accept(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block7;
                }
                case UPDATING: {
                    this.nextNodesUpdate.accept(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block7;
                }
                case DYING: {
                    this.nextNodesRetract.accept(tuple);
                    tuple.setState(BavetTupleState.DEAD);
                    continue block7;
                }
                case ABORTING: {
                    tuple.setState(BavetTupleState.DEAD);
                    continue block7;
                }
                case DEAD: {
                    throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is already in the dead state (" + tuple.getState() + ").");
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.getState() + ").");
        }
        this.dirtyTupleQueue.clear();
    }
}

