/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import org.optaplanner.constraint.streams.bavet.common.index.IndexerKey;
import org.optaplanner.core.impl.util.Pair;
import org.optaplanner.core.impl.util.Quadruple;
import org.optaplanner.core.impl.util.Triple;

public interface IndexProperties {
    public <Type_> Type_ getProperty(int var1);

    public int maxLength();

    default public <Type_> Type_ getIndexerKey(int fromInclusive, int toExclusive) {
        int length = toExclusive - fromInclusive;
        if (length < 1 || length > this.maxLength()) {
            throw new IllegalArgumentException("Impossible state: key length (" + length + ").");
        }
        if (fromInclusive >= toExclusive) {
            throw new IllegalArgumentException("Impossible state: key from (" + fromInclusive + ") >= key to (" + toExclusive + ").");
        }
        switch (length) {
            case 1: {
                return this.getProperty(fromInclusive);
            }
            case 2: {
                return (Type_)Pair.of(this.getProperty(fromInclusive), this.getProperty(fromInclusive + 1));
            }
            case 3: {
                return (Type_)Triple.of(this.getProperty(fromInclusive), this.getProperty(fromInclusive + 1), this.getProperty(fromInclusive + 2));
            }
            case 4: {
                return (Type_)Quadruple.of(this.getProperty(fromInclusive), this.getProperty(fromInclusive + 1), this.getProperty(fromInclusive + 2), this.getProperty(fromInclusive + 3));
            }
        }
        return (Type_)new IndexerKey(this, fromInclusive, toExclusive);
    }
}

