/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.quad.AbstractGroupQuadNode;
import org.optaplanner.constraint.streams.bavet.quad.QuadTuple;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.util.Triple;

final class Group3Mapping1CollectorQuadNode<OldA, OldB, OldC, OldD, A, B, C, D, ResultContainer_>
extends AbstractGroupQuadNode<OldA, OldB, OldC, OldD, QuadTuple<A, B, C, D>, Triple<A, B, C>, ResultContainer_, D> {
    private final QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA;
    private final QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB;
    private final QuadFunction<OldA, OldB, OldC, OldD, C> groupKeyMappingC;
    private final int outputStoreSize;

    public Group3Mapping1CollectorQuadNode(QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA, QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB, QuadFunction<OldA, OldB, OldC, OldD, C> groupKeyMappingC, int groupStoreIndex, QuadConstraintCollector<OldA, OldB, OldC, OldD, ResultContainer_, D> collector, Consumer<QuadTuple<A, B, C, D>> nextNodesInsert, Consumer<QuadTuple<A, B, C, D>> nextNodesRetract, int outputStoreSize) {
        super(groupStoreIndex, collector, nextNodesInsert, nextNodesRetract);
        this.groupKeyMappingA = groupKeyMappingA;
        this.groupKeyMappingB = groupKeyMappingB;
        this.groupKeyMappingC = groupKeyMappingC;
        this.outputStoreSize = outputStoreSize;
    }

    @Override
    protected Triple<A, B, C> createGroupKey(QuadTuple<OldA, OldB, OldC, OldD> tuple) {
        Object oldA = tuple.factA;
        Object oldB = tuple.factB;
        Object oldC = tuple.factC;
        Object oldD = tuple.factD;
        Object a = this.groupKeyMappingA.apply(oldA, oldB, oldC, oldD);
        Object b = this.groupKeyMappingB.apply(oldA, oldB, oldC, oldD);
        Object c = this.groupKeyMappingC.apply(oldA, oldB, oldC, oldD);
        return Triple.of((Object)a, (Object)b, (Object)c);
    }

    @Override
    protected QuadTuple<A, B, C, D> createOutTuple(Group<QuadTuple<A, B, C, D>, Triple<A, B, C>, ResultContainer_> group) {
        Triple groupKey = (Triple)group.groupKey;
        Object d = this.finisher.apply(group.resultContainer);
        return new QuadTuple(groupKey.getA(), groupKey.getB(), groupKey.getC(), d, this.outputStoreSize);
    }

    public String toString() {
        return "GroupQuadNode 3+1";
    }
}

