/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.reload;

import io.quarkus.runtime.StartupEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.optaweb.vehiclerouting.service.vehicle.VehicleService;

@ApplicationScoped
public class ReloadService {
    private final VehicleRepository vehicleRepository;
    private final VehicleService vehicleService;
    private final LocationRepository locationRepository;
    private final LocationService locationService;

    public ReloadService() {
    }

    @Inject
    ReloadService(VehicleRepository vehicleRepository, VehicleService vehicleService, LocationRepository locationRepository, LocationService locationService) {
        this.vehicleRepository = vehicleRepository;
        this.vehicleService = vehicleService;
        this.locationRepository = locationRepository;
        this.locationService = locationService;
    }

    public void reload(@Observes StartupEvent startupEvent) {
        this.vehicleRepository.vehicles().forEach(this.vehicleService::addVehicle);
        this.locationService.populateDistanceMatrix();
        this.locationRepository.locations().forEach(this.locationService::addLocation);
    }
}

