/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move.composite;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.factory.MoveIteratorFactoryConfig;
import org.optaplanner.core.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.PillarChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.SubChainChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.SubChainSwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;

@XmlType(propOrder={"moveSelectorConfigList", "ignoreEmptyChildIterators"})
public class CartesianProductMoveSelectorConfig
extends MoveSelectorConfig<CartesianProductMoveSelectorConfig> {
    public static final String XML_ELEMENT_NAME = "cartesianProductMoveSelector";
    @XmlElements(value={@XmlElement(name="cartesianProductMoveSelector", type=CartesianProductMoveSelectorConfig.class), @XmlElement(name="changeMoveSelector", type=ChangeMoveSelectorConfig.class), @XmlElement(name="moveIteratorFactory", type=MoveIteratorFactoryConfig.class), @XmlElement(name="moveListFactory", type=MoveListFactoryConfig.class), @XmlElement(name="pillarChangeMoveSelector", type=PillarChangeMoveSelectorConfig.class), @XmlElement(name="pillarSwapMoveSelector", type=PillarSwapMoveSelectorConfig.class), @XmlElement(name="subChainChangeMoveSelector", type=SubChainChangeMoveSelectorConfig.class), @XmlElement(name="subChainSwapMoveSelector", type=SubChainSwapMoveSelectorConfig.class), @XmlElement(name="swapMoveSelector", type=SwapMoveSelectorConfig.class), @XmlElement(name="tailChainSwapMoveSelector", type=TailChainSwapMoveSelectorConfig.class), @XmlElement(name="unionMoveSelector", type=UnionMoveSelectorConfig.class)})
    private List<MoveSelectorConfig> moveSelectorConfigList = null;
    private Boolean ignoreEmptyChildIterators = null;

    public CartesianProductMoveSelectorConfig() {
    }

    public CartesianProductMoveSelectorConfig(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    @Deprecated
    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.getMoveSelectorList();
    }

    @Deprecated
    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.setMoveSelectorList(moveSelectorConfigList);
    }

    public List<MoveSelectorConfig> getMoveSelectorList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public Boolean getIgnoreEmptyChildIterators() {
        return this.ignoreEmptyChildIterators;
    }

    public void setIgnoreEmptyChildIterators(Boolean ignoreEmptyChildIterators) {
        this.ignoreEmptyChildIterators = ignoreEmptyChildIterators;
    }

    public CartesianProductMoveSelectorConfig withMoveSelectorList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
        return this;
    }

    public CartesianProductMoveSelectorConfig withMoveSelectors(MoveSelectorConfig ... moveSelectorConfigs) {
        this.moveSelectorConfigList = Arrays.asList(moveSelectorConfigs);
        return this;
    }

    public CartesianProductMoveSelectorConfig withIgnoreEmptyChildIterators(Boolean ignoreEmptyChildIterators) {
        this.ignoreEmptyChildIterators = ignoreEmptyChildIterators;
        return this;
    }

    @Override
    public void extractLeafMoveSelectorConfigsIntoList(List<MoveSelectorConfig> leafMoveSelectorConfigList) {
        for (MoveSelectorConfig moveSelectorConfig : this.moveSelectorConfigList) {
            moveSelectorConfig.extractLeafMoveSelectorConfigsIntoList(leafMoveSelectorConfigList);
        }
    }

    @Override
    public CartesianProductMoveSelectorConfig inherit(CartesianProductMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListConfig(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorList());
        this.ignoreEmptyChildIterators = ConfigUtils.inheritOverwritableProperty(this.ignoreEmptyChildIterators, inheritedConfig.getIgnoreEmptyChildIterators());
        return this;
    }

    @Override
    public CartesianProductMoveSelectorConfig copyConfig() {
        return new CartesianProductMoveSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(Consumer<Class<?>> classVisitor) {
        this.visitCommonReferencedClasses(classVisitor);
        if (this.moveSelectorConfigList != null) {
            this.moveSelectorConfigList.forEach(ms -> ms.visitReferencedClasses(classVisitor));
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.moveSelectorConfigList + ")";
    }
}

