/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.index;

import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.ListVariableListener;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class IndexVariableListener<Solution_>
implements ListVariableListener<Solution_, Object>,
IndexVariableSupply {
    protected final IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    public IndexVariableListener(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.updateIndexes((InnerScoreDirector)scoreDirector, entity, 0);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (Object element : listVariable) {
            innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
            this.shadowVariableDescriptor.setValue(element, null);
            innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
        }
    }

    @Override
    public void beforeElementAdded(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
    }

    @Override
    public void afterElementAdded(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
        this.updateIndexes((InnerScoreDirector)scoreDirector, entity, index);
    }

    @Override
    public void beforeElementRemoved(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object element = this.sourceVariableDescriptor.getElement(entity, index);
        innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, null);
        innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public void afterElementRemoved(ScoreDirector<Solution_> scoreDirector, Object entity, int index) {
        this.updateIndexes((InnerScoreDirector)scoreDirector, entity, index);
    }

    @Override
    public void beforeElementMoved(ScoreDirector<Solution_> scoreDirector, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
    }

    @Override
    public void afterElementMoved(ScoreDirector<Solution_> scoreDirector, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        this.updateIndexes(innerScoreDirector, sourceEntity, sourceIndex);
        this.updateIndexes(innerScoreDirector, destinationEntity, destinationIndex);
    }

    private void updateIndexes(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity, int startIndex) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (int i = startIndex; i < listVariable.size(); ++i) {
            Object element = listVariable.get(i);
            Integer oldIndex = this.shadowVariableDescriptor.getValue(element);
            if (!Objects.equals(oldIndex, i)) {
                scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
                this.shadowVariableDescriptor.setValue(element, i);
                scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
                continue;
            }
            if (i == startIndex) continue;
            return;
        }
    }

    @Override
    public Integer getIndex(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

