/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.ListUnassignMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class ListAssignMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object planningValue;
    private final Object destinationEntity;
    private final int destinationIndex;

    public ListAssignMove(ListVariableDescriptor<Solution_> variableDescriptor, Object planningValue, Object destinationEntity, int destinationIndex) {
        this.variableDescriptor = variableDescriptor;
        this.planningValue = planningValue;
        this.destinationEntity = destinationEntity;
        this.destinationIndex = destinationIndex;
    }

    public Object getDestinationEntity() {
        return this.destinationEntity;
    }

    public int getDestinationIndex() {
        return this.destinationIndex;
    }

    public Object getMovedValue() {
        return this.planningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public ListUnassignMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new ListUnassignMove<Solution_>(this.variableDescriptor, this.destinationEntity, this.destinationIndex);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        innerScoreDirector.beforeElementAdded(this.variableDescriptor, this.destinationEntity, this.destinationIndex);
        this.variableDescriptor.addElement(this.destinationEntity, this.destinationIndex, this.planningValue);
        innerScoreDirector.afterElementAdded(this.variableDescriptor, this.destinationEntity, this.destinationIndex);
    }

    @Override
    public ListAssignMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ListAssignMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.planningValue), destinationScoreDirector.lookUpWorkingObject(this.destinationEntity), this.destinationIndex);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListAssignMove other = (ListAssignMove)o;
        return this.destinationIndex == other.destinationIndex && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.planningValue, other.planningValue) && Objects.equals(this.destinationEntity, other.destinationEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.planningValue, this.destinationEntity, this.destinationIndex);
    }

    public String toString() {
        return String.format("%s {null -> %s[%d]}", this.getMovedValue(), this.destinationEntity, this.destinationIndex);
    }
}

