/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.OriginalListChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomListChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class ListChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntitySelector<Solution_> entitySelector;
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final boolean randomSelection;
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public ListChangeMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, EntitySelector<Solution_> entitySelector, EntityIndependentValueSelector<Solution_> valueSelector, boolean randomSelection) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand<Solution_>(this.listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand<Solution_>(this.listVariableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public long getSize() {
        long entityCount = this.entitySelector.getSize();
        long valueCount = this.valueSelector.getSize();
        int assignedValueCount = StreamSupport.stream(Spliterators.spliterator(this.entitySelector.endingIterator(), this.entitySelector.getSize(), 0), false).mapToInt(this.listVariableDescriptor::getListSize).sum();
        return valueCount * (entityCount + (long)assignedValueCount);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (this.randomSelection) {
            return new RandomListChangeIterator<Solution_>(this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply, this.valueSelector, this.entitySelector, this.workingRandom);
        }
        return new OriginalListChangeIterator<Solution_>(this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply, this.valueSelector, this.entitySelector);
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }
}

