/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.accessor;

import java.io.Serializable;
import java.security.AccessController;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.CompiledInvoker;
import org.drools.core.rule.accessor.Invoker;
import org.kie.internal.security.KiePolicyHelper;

public interface EvalExpression
extends Invoker,
Cloneable {
    public Object createContext();

    public boolean evaluate(Tuple var1, Declaration[] var2, ReteEvaluator var3, Object var4) throws Exception;

    public void replaceDeclaration(Declaration var1, Declaration var2);

    public EvalExpression clone();

    default public EvalExpression clonePreservingDeclarations(EvalExpression original) {
        return original;
    }

    public static class SafeEvalExpression
    implements EvalExpression,
    Serializable {
        private static final long serialVersionUID = -5682290553015978731L;
        private EvalExpression delegate;

        public SafeEvalExpression(EvalExpression delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object createContext() {
            return AccessController.doPrivileged(() -> this.delegate.createContext(), KiePolicyHelper.getAccessContext());
        }

        @Override
        public boolean evaluate(Tuple tuple, Declaration[] requiredDeclarations, ReteEvaluator reteEvaluator, Object context) throws Exception {
            return AccessController.doPrivileged(() -> this.delegate.evaluate(tuple, requiredDeclarations, reteEvaluator, context), KiePolicyHelper.getAccessContext());
        }

        @Override
        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
            this.delegate.replaceDeclaration(declaration, resolved);
        }

        @Override
        public SafeEvalExpression clone() {
            return new SafeEvalExpression(this.delegate.clone());
        }

        @Override
        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

