/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.internal.utils.KieService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface InternalKieModuleProvider
extends KieService {
    default public InternalKieModule createClasspathKieModule() {
        return null;
    }

    public InternalKieModule createKieModule(ReleaseId var1, KieModuleModel var2, File var3);

    public InternalKieModule createKieModule(ReleaseId var1, KieModuleModel var2, MemoryFileSystem var3);

    public static InternalKieModule get(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        return Factory.get().createKieModule(releaseId, kieProject, file);
    }

    public static InternalKieModule get(ReleaseId releaseId, KieModuleModel kieProject, MemoryFileSystem mfs) {
        return Factory.get().createKieModule(releaseId, kieProject, mfs);
    }

    public static InternalKieModule getFromClasspath() {
        return Factory.get().createClasspathKieModule();
    }

    public static class Factory {
        private static InternalKieModuleProvider createZipKieModuleProvider() {
            InternalKieModuleProvider provider = (InternalKieModuleProvider)KieService.load(InternalKieModuleProvider.class);
            return provider != null ? provider : new DrlBasedKieModuleProvider();
        }

        public static InternalKieModuleProvider get() {
            return LazyHolder.INSTANCE;
        }

        static /* synthetic */ InternalKieModuleProvider access$000() {
            return Factory.createZipKieModuleProvider();
        }

        private static class LazyHolder {
            private static InternalKieModuleProvider INSTANCE = Factory.access$000();

            private LazyHolder() {
            }
        }
    }

    public static class DrlBasedKieModuleProvider
    implements InternalKieModuleProvider {
        private static final Logger log = LoggerFactory.getLogger(InternalKieModuleProvider.class);

        @Override
        public InternalKieModule createKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
            if (log.isInfoEnabled()) {
                log.info("Creating KieModule for artifact " + releaseId);
            }
            return file.isDirectory() ? new FileKieModule(releaseId, kieProject, file) : new ZipKieModule(releaseId, kieProject, file);
        }

        @Override
        public InternalKieModule createKieModule(ReleaseId releaseId, KieModuleModel kieProject, MemoryFileSystem mfs) {
            if (log.isInfoEnabled()) {
                log.info("Creating in memory KieModule for artifact " + releaseId);
            }
            return new MemoryKieModule(releaseId, kieProject, mfs);
        }
    }
}

