/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta;

import com.arjuna.ats.jta.UserTransaction;
import io.quarkus.arc.Arc;
import io.quarkus.narayana.jta.BeginOptions;
import io.quarkus.narayana.jta.QuarkusTransactionException;
import io.quarkus.narayana.jta.QuarkusTransactionImpl;
import io.quarkus.narayana.jta.RequestScopedTransaction;
import io.quarkus.narayana.jta.RunOptions;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.transaction.SystemException;

public interface QuarkusTransaction {
    public static void begin() {
        QuarkusTransaction.begin(QuarkusTransaction.beginOptions());
    }

    public static void begin(BeginOptions options) {
        RequestScopedTransaction tx = (RequestScopedTransaction)Arc.container().instance(RequestScopedTransaction.class, new Annotation[0]).get();
        tx.begin(options);
    }

    public static void commit() {
        QuarkusTransactionImpl.commit();
    }

    public static void rollback() {
        QuarkusTransactionImpl.rollback();
    }

    public static boolean isActive() {
        try {
            return UserTransaction.userTransaction().getStatus() != 6;
        }
        catch (SystemException e) {
            throw new QuarkusTransactionException(e);
        }
    }

    public static boolean isRollbackOnly() {
        try {
            return UserTransaction.userTransaction().getStatus() == 1;
        }
        catch (SystemException e) {
            throw new QuarkusTransactionException(e);
        }
    }

    public static void setRollbackOnly() {
        QuarkusTransactionImpl.setRollbackOnly();
    }

    public static void run(Runnable task) {
        QuarkusTransaction.run(QuarkusTransaction.runOptions(), task);
    }

    public static void run(RunOptions options, final Runnable task) {
        QuarkusTransaction.call(options, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                task.run();
                return null;
            }
        });
    }

    public static <T> T call(Callable<T> task) {
        return QuarkusTransaction.call(QuarkusTransaction.runOptions(), task);
    }

    public static <T> T call(RunOptions options, Callable<T> task) {
        return QuarkusTransactionImpl.call(options, task);
    }

    public static RunOptions runOptions() {
        return new RunOptions();
    }

    public static BeginOptions beginOptions() {
        return new BeginOptions();
    }
}

