/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.util.Set;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.quad.BavetAbstractQuadConstraintStream;
import org.optaplanner.constraint.streams.bavet.quad.IfExistsQuadWithUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetIfExistsBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.common.penta.DefaultPentaJoiner;
import org.optaplanner.core.api.function.PentaPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

final class BavetIfExistsQuadConstraintStream<Solution_, A, B, C, D, E>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> {
    private final BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parentABCD;
    private final BavetIfExistsBridgeUniConstraintStream<Solution_, E> parentBridgeE;
    private final boolean shouldExist;
    private final DefaultPentaJoiner<A, B, C, D, E> joiner;
    private final PentaPredicate<A, B, C, D, E> filtering;

    public BavetIfExistsQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parentABCD, BavetIfExistsBridgeUniConstraintStream<Solution_, E> parentBridgeE, boolean shouldExist, DefaultPentaJoiner<A, B, C, D, E> joiner, PentaPredicate<A, B, C, D, E> filtering) {
        super(constraintFactory, parentABCD.getRetrievalSemantics());
        this.parentABCD = parentABCD;
        this.parentBridgeE = parentBridgeE;
        this.shouldExist = shouldExist;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    public boolean guaranteesDistinct() {
        return this.parentABCD.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parentABCD.collectActiveConstraintStreams(constraintStreamSet);
        this.parentBridgeE.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parentABCD.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int inputStoreIndexA = buildHelper.reserveTupleStoreIndex(this.parentABCD.getTupleSource());
        int inputStoreIndexB = buildHelper.reserveTupleStoreIndex(this.parentBridgeE.getTupleSource());
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory((AbstractJoiner)this.joiner);
        Indexer indexerABCD = indexerFactory.buildIndexer(true);
        Indexer indexerE = indexerFactory.buildIndexer(false);
        IfExistsQuadWithUniNode node = new IfExistsQuadWithUniNode(this.shouldExist, JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), inputStoreIndexA, inputStoreIndexB, insert, retract, indexerABCD, indexerE, this.filtering);
        buildHelper.addNode(node);
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, node::insertLeft, node::updateLeft, node::retractLeft);
        buildHelper.putInsertUpdateRetract((ConstraintStream)this.parentBridgeE, node::insertRight, node::updateRight, node::retractRight);
    }

    public String toString() {
        return "IfExists() with " + this.childStreamList.size() + " children";
    }
}

