/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.quad.AbstractGroupQuadNode;
import org.optaplanner.constraint.streams.bavet.quad.QuadTuple;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.impl.util.Quadruple;

final class Group4Mapping0CollectorQuadNode<OldA, OldB, OldC, OldD, A, B, C, D>
extends AbstractGroupQuadNode<OldA, OldB, OldC, OldD, QuadTuple<A, B, C, D>, Quadruple<A, B, C, D>, Void, Void> {
    private final QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA;
    private final QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB;
    private final QuadFunction<OldA, OldB, OldC, OldD, C> groupKeyMappingC;
    private final QuadFunction<OldA, OldB, OldC, OldD, D> groupKeyMappingD;
    private final int outputStoreSize;

    public Group4Mapping0CollectorQuadNode(QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA, QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB, QuadFunction<OldA, OldB, OldC, OldD, C> groupKeyMappingC, QuadFunction<OldA, OldB, OldC, OldD, D> groupKeyMappingD, int groupStoreIndex, Consumer<QuadTuple<A, B, C, D>> nextNodesInsert, Consumer<QuadTuple<A, B, C, D>> nextNodesRetract, int outputStoreSize) {
        super(groupStoreIndex, null, nextNodesInsert, nextNodesRetract);
        this.groupKeyMappingA = groupKeyMappingA;
        this.groupKeyMappingB = groupKeyMappingB;
        this.groupKeyMappingC = groupKeyMappingC;
        this.groupKeyMappingD = groupKeyMappingD;
        this.outputStoreSize = outputStoreSize;
    }

    @Override
    protected Quadruple<A, B, C, D> createGroupKey(QuadTuple<OldA, OldB, OldC, OldD> tuple) {
        Object oldA = tuple.factA;
        Object oldB = tuple.factB;
        Object oldC = tuple.factC;
        Object oldD = tuple.factD;
        Object a = this.groupKeyMappingA.apply(oldA, oldB, oldC, oldD);
        Object b = this.groupKeyMappingB.apply(oldA, oldB, oldC, oldD);
        Object c = this.groupKeyMappingC.apply(oldA, oldB, oldC, oldD);
        Object d = this.groupKeyMappingD.apply(oldA, oldB, oldC, oldD);
        return Quadruple.of((Object)a, (Object)b, (Object)c, (Object)d);
    }

    @Override
    protected QuadTuple<A, B, C, D> createOutTuple(Group<QuadTuple<A, B, C, D>, Quadruple<A, B, C, D>, Void> group) {
        Quadruple key = (Quadruple)group.groupKey;
        return new QuadTuple<Object, Object, Object, Object>(key.getA(), key.getB(), key.getC(), key.getD(), this.outputStoreSize);
    }

    public String toString() {
        return "GroupQuadNode 4+0";
    }
}

