/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.Map;
import org.jboss.logmanager.FastCopyHashMap;
import org.jboss.logmanager.MDCProvider;

final class ThreadLocalMDC
implements MDCProvider {
    private static final Holder mdc = new Holder();

    ThreadLocalMDC() {
    }

    @Override
    public String get(String key) {
        Object value = this.getObject(key);
        return value == null ? null : value.toString();
    }

    @Override
    public Object getObject(String key) {
        return ((FastCopyHashMap)mdc.get()).get(key);
    }

    @Override
    public String put(String key, String value) {
        Object oldValue = this.putObject(key, value);
        return oldValue == null ? null : oldValue.toString();
    }

    @Override
    public Object putObject(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        return ((FastCopyHashMap)mdc.get()).put(key, value);
    }

    @Override
    public String remove(String key) {
        Object oldValue = this.removeObject(key);
        return oldValue == null ? null : oldValue.toString();
    }

    @Override
    public Object removeObject(String key) {
        return ((FastCopyHashMap)mdc.get()).remove(key);
    }

    @Override
    public Map<String, String> copy() {
        FastCopyHashMap<String, String> result = new FastCopyHashMap<String, String>();
        for (Map.Entry entry : ((FastCopyHashMap)mdc.get()).entrySet()) {
            result.put((String)entry.getKey(), entry.getValue().toString());
        }
        return result;
    }

    @Override
    public Map<String, Object> copyObject() {
        return ((FastCopyHashMap)mdc.get()).clone();
    }

    @Override
    public void clear() {
        ((FastCopyHashMap)mdc.get()).clear();
    }

    private static final class Holder
    extends InheritableThreadLocal<FastCopyHashMap<String, Object>> {
        private Holder() {
        }

        @Override
        protected FastCopyHashMap<String, Object> childValue(FastCopyHashMap<String, Object> parentValue) {
            return new FastCopyHashMap<String, Object>(parentValue);
        }

        @Override
        protected FastCopyHashMap<String, Object> initialValue() {
            return new FastCopyHashMap<String, Object>();
        }
    }
}

