/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.core.common.BaseNode;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMemory
extends LinkedList<SegmentMemory>
implements LinkedListNode<SegmentMemory> {
    protected static final Logger log = LoggerFactory.getLogger(SegmentMemory.class);
    protected static final boolean IS_LOG_TRACE_ENABLED = log.isTraceEnabled();
    private SegmentPrototype proto;
    private List<Memory> nodeMemories = new ArrayList<Memory>();
    private List<PathMemory> pathMemories = new ArrayList<PathMemory>(1);
    private TupleSets<LeftTuple> stagedLeftTuples = new TupleSetsImpl<LeftTuple>();
    private long linkedNodeMask;
    private long dirtyNodeMask;
    private long allLinkedMaskTest;
    private long segmentPosMaskBit;
    private int pos = -1;
    private boolean active;
    private SegmentMemory previous;
    private SegmentMemory next;
    private transient List<PathMemory> dataDrivenPathMemories;
    private transient List<SegmentMemory> peersWithDataDrivenPathMemories;

    public LeftTupleNode getRootNode() {
        return this.proto.getRootNode();
    }

    public SegmentPrototype getSegmentPrototype() {
        return this.proto;
    }

    public LeftTupleNode getTipNode() {
        return this.proto.getTipNode();
    }

    public LeftTupleSink getSinkFactory() {
        return (LeftTupleSink)this.proto.getRootNode();
    }

    public <T extends Memory> T createNodeMemory(MemoryFactory<T> memoryFactory, ReteEvaluator reteEvaluator) {
        T memory = reteEvaluator.getNodeMemory(memoryFactory);
        this.nodeMemories.add((Memory)memory);
        return memory;
    }

    public List<Memory> getNodeMemories() {
        return this.nodeMemories;
    }

    public long getLinkedNodeMask() {
        return this.linkedNodeMask;
    }

    public void setLinkedNodeMask(long linkedNodeMask) {
        this.linkedNodeMask = linkedNodeMask;
    }

    public long getDirtyNodeMask() {
        return this.dirtyNodeMask;
    }

    public void setDirtyNodeMask(long dirtyNodeMask) {
        this.dirtyNodeMask = dirtyNodeMask;
    }

    public void updateDirtyNodeMask(long mask) {
        this.dirtyNodeMask |= mask;
    }

    public void updateCleanNodeMask(long mask) {
        this.dirtyNodeMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public String getRuleNames() {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.pathMemories.size(); ++i) {
            if (i > 0) {
                sbuilder.append(", ");
            }
            sbuilder.append(this.pathMemories.get(i));
        }
        return sbuilder.toString();
    }

    public boolean linkNode(long mask, ReteEvaluator reteEvaluator) {
        this.linkedNodeMask |= mask;
        this.dirtyNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("LinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        return this.notifyRuleLinkSegment(reteEvaluator);
    }

    public boolean linkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask |= mask;
        this.dirtyNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("LinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        return this.linkSegmentWithoutRuleNotify();
    }

    public boolean linkSegmentWithoutRuleNotify(long mask) {
        this.dirtyNodeMask |= mask;
        return this.linkSegmentWithoutRuleNotify();
    }

    private boolean linkSegmentWithoutRuleNotify() {
        boolean dataDrivePmemLinked = false;
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                pmem.linkSegmentWithoutRuleNotify(this.segmentPosMaskBit);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
            }
        }
        return dataDrivePmemLinked;
    }

    public boolean notifyRuleLinkSegment(ReteEvaluator reteEvaluator, long mask) {
        this.dirtyNodeMask |= mask;
        return this.notifyRuleLinkSegment(reteEvaluator);
    }

    public boolean notifyRuleLinkSegment(ReteEvaluator reteEvaluator) {
        boolean dataDrivePmemLinked = false;
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                this.notifyRuleLinkSegment(reteEvaluator, pmem);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
            }
        }
        return dataDrivePmemLinked;
    }

    public void notifyRuleLinkSegment(ReteEvaluator reteEvaluator, PathMemory pmem) {
        pmem.linkSegment(this.segmentPosMaskBit, reteEvaluator);
    }

    public boolean unlinkNode(long mask, ReteEvaluator reteEvaluator) {
        boolean dataDrivePmemLinked = false;
        boolean linked = this.isSegmentLinked();
        this.linkedNodeMask ^= mask;
        this.dirtyNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("UnlinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        if (linked && !this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
                pmem.unlinkedSegment(this.segmentPosMaskBit, reteEvaluator);
            }
        } else {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                if (!this.pathMemories.get(i).isRuleLinked()) continue;
                this.pathMemories.get(i).doLinkRule(reteEvaluator);
            }
        }
        return dataDrivePmemLinked;
    }

    public void unlinkSegment(ReteEvaluator reteEvaluator) {
        int length = this.pathMemories.size();
        for (int i = 0; i < length; ++i) {
            this.pathMemories.get(i).unlinkedSegment(this.segmentPosMaskBit, reteEvaluator);
        }
    }

    public void unlinkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask ^= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("UnlinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public boolean isSegmentLinked() {
        return (this.linkedNodeMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public List<PathMemory> getPathMemories() {
        return this.pathMemories;
    }

    public void addPathMemory(PathMemory pathMemory) {
        this.pathMemories.add(pathMemory);
        if (this.isSegmentLinked()) {
            pathMemory.linkSegmentWithoutRuleNotify(this.segmentPosMaskBit);
        }
        if (pathMemory.isDataDriven()) {
            if (this.dataDrivenPathMemories == null) {
                this.dataDrivenPathMemories = new ArrayList<PathMemory>();
            }
            this.dataDrivenPathMemories.add(pathMemory);
        }
    }

    public void mergePathMemories(SegmentMemory segmentMemory) {
        for (PathMemory pmem : segmentMemory.getPathMemories()) {
            if (!this.isAssociatedWith(pmem)) continue;
            this.addPathMemory(pmem);
        }
    }

    private boolean isAssociatedWith(PathMemory pmem) {
        if (71 == pmem.getNodeType()) {
            for (PathEndNode endNode : pmem.getPathEndNode().getPathEndNodes()) {
                if (!NodeTypeEnums.isTerminalNode(endNode) || !this.proto.getRootNode().getAssociatedTerminals().containsKey(endNode.getId())) continue;
                return true;
            }
            return false;
        }
        return this.proto.getRootNode().getAssociatedTerminals().containsKey(pmem.getPathEndNode().getId());
    }

    public void removePathMemory(PathMemory pathMemory) {
        this.pathMemories.remove(pathMemory);
        if (pathMemory.isDataDriven()) {
            this.dataDrivenPathMemories.remove(pathMemory);
            if (this.dataDrivenPathMemories.isEmpty()) {
                this.dataDrivenPathMemories = null;
            }
        }
    }

    public PathMemory getFirstDataDrivenPathMemory() {
        return this.dataDrivenPathMemories == null ? null : this.dataDrivenPathMemories.get(0);
    }

    public boolean hasDataDrivenPathMemories() {
        return this.dataDrivenPathMemories != null;
    }

    public List<PathMemory> getDataDrivenPathMemories() {
        return this.dataDrivenPathMemories;
    }

    public long getSegmentPosMaskBit() {
        return this.segmentPosMaskBit;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean evaluating) {
        this.active = evaluating;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public TupleSets<LeftTuple> getStagedLeftTuples() {
        return this.stagedLeftTuples;
    }

    @Override
    public void add(SegmentMemory segmentMemory) {
        super.add(segmentMemory);
        if (segmentMemory.hasDataDrivenPathMemories()) {
            if (this.peersWithDataDrivenPathMemories == null) {
                this.peersWithDataDrivenPathMemories = new ArrayList<SegmentMemory>();
            }
            this.peersWithDataDrivenPathMemories.add(segmentMemory);
        }
    }

    @Override
    public void remove(SegmentMemory segmentMemory) {
        super.remove(segmentMemory);
        if (this.peersWithDataDrivenPathMemories != null) {
            this.peersWithDataDrivenPathMemories.remove(segmentMemory);
            if (this.peersWithDataDrivenPathMemories.isEmpty()) {
                this.peersWithDataDrivenPathMemories = null;
            }
        }
    }

    public Iterator<SegmentMemory> getPeersWithDataDrivenPathMemoriesIterator() {
        return this.peersWithDataDrivenPathMemories == null ? Collections.emptyIterator() : this.peersWithDataDrivenPathMemories.iterator();
    }

    @Override
    public SegmentMemory getNext() {
        return this.next;
    }

    @Override
    public void setNext(SegmentMemory next) {
        this.next = next;
    }

    @Override
    public SegmentMemory getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(SegmentMemory previous) {
        this.previous = previous;
    }

    @Override
    public void nullPrevNext() {
        this.previous = null;
        this.next = null;
    }

    @Override
    public int hashCode() {
        return this.proto.getRootNode().getId();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SegmentMemory && this.proto.getRootNode().getId() == ((SegmentMemory)obj).proto.getRootNode().getId() && this.proto.getTipNode().getId() == ((SegmentMemory)obj).proto.getTipNode().getId();
    }

    public void reset(SegmentPrototype segmentPrototype) {
        this.dirtyNodeMask = 0L;
        this.linkedNodeMask = segmentPrototype != null ? segmentPrototype.linkedNodeMask : 0L;
        this.stagedLeftTuples.resetAll();
    }

    public String toString() {
        return "Segment root " + this.proto.getRootNode() + " tip " + this.proto.getTipNode();
    }

    public static class AccumulateMemoryPrototype
    extends MemoryPrototype {
        private final BetaMemoryPrototype betaProto;

        public AccumulateMemoryPrototype(BetaMemoryPrototype betaProto) {
            this.betaProto = betaProto;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory accMemory) {
            this.betaProto.populateMemory(reteEvaluator, ((AccumulateNode.AccumulateMemory)accMemory).getBetaMemory());
        }
    }

    public static class AsyncReceiveMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        public AsyncReceiveMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
            AsyncReceiveNode.AsyncReceiveMemory amem = (AsyncReceiveNode.AsyncReceiveMemory)mem;
            amem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class AsyncSendMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
        }
    }

    public static class TimerMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        public TimerMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
            TimerNode.TimerNodeMemory tmem = (TimerNode.TimerNodeMemory)mem;
            tmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class QueryMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;
        private final QueryElementNode queryNode;

        public QueryMemoryPrototype(long nodePosMaskBit, QueryElementNode queryNode) {
            this.nodePosMaskBit = nodePosMaskBit;
            this.queryNode = queryNode;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
            QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)mem;
            SegmentMemory querySmem = RuntimeSegmentUtilities.getQuerySegmentMemory(reteEvaluator, (LeftTupleSource)qmem.getSegmentMemory().getRootNode(), this.queryNode);
            qmem.setQuerySegmentMemory(querySmem);
            qmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class EvalMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class FromMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class TerminalPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class RightInputAdapterPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class ConditionalBranchMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class ReactiveFromMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        public ReactiveFromMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
            ((ReactiveFromNode.ReactiveFromMemory)memory).setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class LiaMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;

        public LiaMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory liaMemory) {
            ((SegmentNodeMemory)liaMemory).setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class BetaMemoryPrototype
    extends MemoryPrototype {
        private final long nodePosMaskBit;
        private final RightInputAdapterNode riaNode;

        public BetaMemoryPrototype(long nodePosMaskBit, RightInputAdapterNode riaNode) {
            this.nodePosMaskBit = nodePosMaskBit;
            this.riaNode = riaNode;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
            BetaMemory betaMemory = (BetaMemory)memory;
            betaMemory.setNodePosMaskBit(this.nodePosMaskBit);
            if (this.riaNode != null) {
                RightInputAdapterNode.RiaPathMemory riaMem = (RightInputAdapterNode.RiaPathMemory)reteEvaluator.getNodeMemories().peekNodeMemory(this.riaNode);
                if (riaMem == null) {
                    riaMem = (RightInputAdapterNode.RiaPathMemory)RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, this.riaNode);
                }
                betaMemory.setRiaRuleMemory(riaMem);
            }
        }
    }

    public static abstract class MemoryPrototype {
        public abstract void populateMemory(ReteEvaluator var1, Memory var2);
    }

    public static class SegmentPrototype {
        LeftTupleNode rootNode;
        LeftTupleNode tipNode;
        long linkedNodeMask;
        long allLinkedMaskTest;
        long segmentPosMaskBit;
        int pos;
        MemoryPrototype[] memories;
        LeftTupleNode[] nodesInSegment;
        PathEndNode[] pathEndNodes;
        int nodeTypesInSegment = 0;

        public SegmentPrototype(LeftTupleNode rootNode, LeftTupleNode tipNode) {
            this.rootNode = rootNode;
            this.tipNode = tipNode;
        }

        public SegmentMemory newSegmentMemory(ReteEvaluator reteEvaluator) {
            SegmentMemory smem = new SegmentMemory();
            this.updateSegmentMemory(smem, reteEvaluator);
            return smem;
        }

        public void updateSegmentMemory(SegmentMemory smem, ReteEvaluator reteEvaluator) {
            smem.proto = this;
            smem.allLinkedMaskTest = this.allLinkedMaskTest;
            smem.segmentPosMaskBit = this.segmentPosMaskBit;
            smem.linkedNodeMask = this.linkedNodeMask;
            smem.pos = this.pos;
            smem.nodeMemories.clear();
            int i = 0;
            for (LeftTupleNode node : this.getNodesInSegment()) {
                Memory mem = reteEvaluator.getNodeMemory((MemoryFactory)((Object)node));
                mem.setSegmentMemory(smem);
                List<Memory> mems = smem.getNodeMemories();
                if (!mems.isEmpty()) {
                    Memory last = mems.get(mems.size() - 1);
                    last.setNext(mem);
                    mem.setPrevious((Memory)last);
                }
                smem.getNodeMemories().add(mem);
                ((BaseNode)((Object)node)).setPosInSegment(i);
                MemoryPrototype proto = this.memories[i];
                if (proto != null) {
                    proto.populateMemory(reteEvaluator, mem);
                }
                ++i;
            }
        }

        public LeftTupleNode getRootNode() {
            return this.rootNode;
        }

        public LeftTupleNode getTipNode() {
            return this.tipNode;
        }

        public void linkNode(long mask) {
            this.linkedNodeMask |= mask;
        }

        public void setAllLinkedMaskTest(long allLinkedMaskTest) {
            this.allLinkedMaskTest = allLinkedMaskTest;
        }

        public void setSegmentPosMaskBit(long segmentPosMaskBit) {
            this.segmentPosMaskBit = segmentPosMaskBit;
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public MemoryPrototype[] getMemories() {
            return this.memories;
        }

        public void setMemories(MemoryPrototype[] memories) {
            this.memories = memories;
        }

        public LeftTupleNode[] getNodesInSegment() {
            return this.nodesInSegment;
        }

        public void setNodesInSegment(LeftTupleNode[] nodesInSegment) {
            this.nodesInSegment = nodesInSegment;
        }

        public int getNodeTypesInSegment() {
            return this.nodeTypesInSegment;
        }

        public void setNodeTypesInSegment(int nodeTypesInSegment) {
            this.nodeTypesInSegment = nodeTypesInSegment;
        }

        public PathEndNode[] getPathEndNodes() {
            return this.pathEndNodes;
        }

        public void setPathEndNodes(PathEndNode[] pathEndNodes) {
            this.pathEndNodes = pathEndNodes;
        }

        public String toString() {
            StringBuilder sbuilder = new StringBuilder();
            sbuilder.append("SegmentMemory[");
            sbuilder.append("root " + this.rootNode + " tip " + this.tipNode + ", ");
            sbuilder.append("linkedNodeMask " + this.linkedNodeMask + ", ");
            sbuilder.append("allLinkedMaskTest " + this.allLinkedMaskTest + ", ");
            sbuilder.append("segmentPosMaskBit " + this.segmentPosMaskBit + ", ");
            sbuilder.append("pos " + this.pos + ", ");
            sbuilder.append("nodeTypesInSegment " + this.nodeTypesInSegment + " ");
            sbuilder.append("nodes ");
            Arrays.stream(this.nodesInSegment).forEach(n -> sbuilder.append(n));
            sbuilder.append("]");
            return sbuilder.toString();
        }
    }
}

