/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.rest.model.RoutingProblemInfo;
import org.optaweb.vehiclerouting.plugin.rest.model.ServerInfo;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.RegionService;

@Path(value="api/serverInfo")
public class ServerInfoResource {
    private final DemoService demoService;
    private final RegionService regionService;

    public /* synthetic */ ServerInfoResource() {
    }

    @Inject
    public ServerInfoResource(DemoService demoService, RegionService regionService) {
        this.demoService = demoService;
        this.regionService = regionService;
    }

    @GET
    @Produces(value={"application/json"})
    public ServerInfo serverInfo() {
        BoundingBox boundingBox = this.regionService.boundingBox();
        List<PortableCoordinates> portableBoundingBox = Arrays.asList(PortableCoordinates.fromCoordinates((Coordinates)boundingBox.getSouthWest()), PortableCoordinates.fromCoordinates((Coordinates)boundingBox.getNorthEast()));
        List demos = this.demoService.demos().stream().map(routingProblem -> new RoutingProblemInfo(routingProblem.name(), routingProblem.visits().size())).collect(Collectors.toList());
        return new ServerInfo(portableBoundingBox, this.regionService.countryCodes(), demos);
    }
}

