/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.transaction.SystemException;
import javax.transaction.TransactionScoped;

public abstract class TransactionScopedNotifier {
    private transient Event<TransactionId> initialized;
    private transient Event<TransactionId> beforeDestroyed;
    private transient Event<TransactionId> destroyed;

    void initialized(TransactionId transactionId) {
        if (this.initialized == null) {
            this.initialized = Arc.container().beanManager().getEvent().select(TransactionId.class, new Annotation[]{Initialized.Literal.of(TransactionScoped.class)});
        }
        this.initialized.fire((Object)transactionId);
    }

    void beforeDestroyed(TransactionId transactionId) {
        if (this.beforeDestroyed == null) {
            this.beforeDestroyed = Arc.container().beanManager().getEvent().select(TransactionId.class, new Annotation[]{BeforeDestroyed.Literal.of(TransactionScoped.class)});
        }
        this.beforeDestroyed.fire((Object)transactionId);
    }

    void destroyed(TransactionId transactionId) {
        if (this.destroyed == null) {
            this.destroyed = Arc.container().beanManager().getEvent().select(TransactionId.class, new Annotation[]{Destroyed.Literal.of(TransactionScoped.class)});
        }
        this.destroyed.fire((Object)transactionId);
    }

    TransactionId getTransactionId() throws SystemException {
        try {
            return new TransactionId(TransactionImple.getTransaction().toString());
        }
        catch (Exception e) {
            throw new SystemException("The transaction is not active!");
        }
    }

    public static final class TransactionId {
        private final String value;

        public TransactionId(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransactionId other = (TransactionId)obj;
            return Objects.equals(this.value, other.value);
        }
    }
}

