/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime.context;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionScoped;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionContext
implements InjectableContext {
    private static final Object TRANSACTION_CONTEXT_MARKER = new Object();
    private final Lock transactionLock = new ReentrantLock();
    private final LazyValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistry = new LazyValue((Supplier)new Supplier<TransactionSynchronizationRegistry>(){

        @Override
        public TransactionSynchronizationRegistry get() {
            return new TransactionSynchronizationRegistryImple();
        }
    });
    private final LazyValue<TransactionManager> transactionManager = new LazyValue((Supplier)new Supplier<TransactionManager>(){

        @Override
        public TransactionManager get() {
            return com.arjuna.ats.jta.TransactionManager.transactionManager();
        }
    });

    public void destroy() {
        if (!this.isActive()) {
            return;
        }
        TransactionContextState contextState = (TransactionContextState)((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.get()).getResource(TRANSACTION_CONTEXT_MARKER);
        if (contextState == null) {
            return;
        }
        contextState.destroy();
    }

    public void destroy(Contextual<?> contextual) {
        if (!this.isActive()) {
            return;
        }
        TransactionContextState contextState = (TransactionContextState)((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.get()).getResource(TRANSACTION_CONTEXT_MARKER);
        if (contextState == null) {
            return;
        }
        contextState.remove(contextual);
    }

    public InjectableContext.ContextState getState() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("No active transaction on the current thread");
        }
        TransactionContextState contextState = (TransactionContextState)((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.get()).getResource(TRANSACTION_CONTEXT_MARKER);
        TransactionContextState result = contextState == null ? new TransactionContextState(this.getCurrentTransaction()) : contextState;
        return result;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        TransactionContextState contextState;
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (contextual == null) {
            throw new IllegalArgumentException("Contextual parameter must not be null");
        }
        TransactionSynchronizationRegistry registryInstance = (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.get();
        this.transactionLock.lock();
        try {
            contextState = (TransactionContextState)registryInstance.getResource(TRANSACTION_CONTEXT_MARKER);
            if (contextState == null) {
                contextState = new TransactionContextState(this.getCurrentTransaction());
                registryInstance.putResource(TRANSACTION_CONTEXT_MARKER, (Object)contextState);
            }
        }
        finally {
            this.transactionLock.unlock();
        }
        ContextInstanceHandleImpl instanceHandle = contextState.get(contextual);
        if (instanceHandle != null) {
            return (T)instanceHandle.get();
        }
        if (creationalContext != null) {
            Lock beanLock = contextState.getLock();
            beanLock.lock();
            try {
                instanceHandle = contextState.get(contextual);
                if (instanceHandle != null) {
                    Object object = instanceHandle.get();
                    return (T)object;
                }
                Object createdInstance = contextual.create(creationalContext);
                instanceHandle = new ContextInstanceHandleImpl((InjectableBean)contextual, createdInstance, creationalContext);
                contextState.put(contextual, instanceHandle);
                Object object = createdInstance;
                return (T)object;
            }
            finally {
                beanLock.unlock();
            }
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        Transaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            return false;
        }
        try {
            int currentStatus = transaction.getStatus();
            return currentStatus == 0 || currentStatus == 1 || currentStatus == 2 || currentStatus == 5 || currentStatus == 7 || currentStatus == 8 || currentStatus == 9;
        }
        catch (SystemException e) {
            throw new RuntimeException("Error getting the status of the current transaction", e);
        }
    }

    private Transaction getCurrentTransaction() {
        try {
            return ((TransactionManager)this.transactionManager.get()).getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException("Error getting the current transaction", e);
        }
    }

    private static class TransactionContextState
    implements InjectableContext.ContextState,
    Synchronization {
        private final Lock lock = new ReentrantLock();
        private final ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> mapBeanToInstanceHandle = new ConcurrentHashMap();

        TransactionContextState(Transaction transaction) {
            try {
                transaction.registerSynchronization((Synchronization)this);
            }
            catch (RollbackException | SystemException e) {
                throw new RuntimeException("Cannot register synchronization", e);
            }
        }

        <T> void put(Contextual<T> bean, ContextInstanceHandle<T> handle) {
            this.mapBeanToInstanceHandle.put(bean, handle);
        }

        <T> void remove(Contextual<T> bean) {
            ContextInstanceHandle instance = (ContextInstanceHandle)this.mapBeanToInstanceHandle.remove(bean);
            if (instance != null) {
                instance.destroy();
            }
        }

        <T> ContextInstanceHandle<T> get(Contextual<T> bean) {
            return (ContextInstanceHandle)this.mapBeanToInstanceHandle.get(bean);
        }

        void destroy() {
            for (ContextInstanceHandle handle : this.mapBeanToInstanceHandle.values()) {
                handle.destroy();
            }
            this.mapBeanToInstanceHandle.clear();
        }

        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.mapBeanToInstanceHandle.values().stream().collect(Collectors.toMap(InstanceHandle::getBean, InstanceHandle::get));
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.destroy();
        }

        public Lock getLock() {
            return this.lock;
        }
    }
}

