/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Queue;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleList;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    protected final int inputStoreIndexLeftOutTupleList;
    protected final int inputStoreIndexRightOutTupleList;
    private final TupleLifecycle<OutTuple_> nextNodesTupleLifecycle;
    protected final boolean isFiltering;
    protected final int outputStoreIndexLeftOutEntry;
    protected final int outputStoreIndexRightOutEntry;
    protected final Queue<OutTuple_> dirtyTupleQueue;

    protected AbstractJoinNode(int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry) {
        this.inputStoreIndexLeftOutTupleList = inputStoreIndexLeftOutTupleList;
        this.inputStoreIndexRightOutTupleList = inputStoreIndexRightOutTupleList;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.isFiltering = isFiltering;
        this.outputStoreIndexLeftOutEntry = outputStoreIndexLeftOutEntry;
        this.outputStoreIndexRightOutEntry = outputStoreIndexRightOutEntry;
        this.dirtyTupleQueue = new ArrayDeque<OutTuple_>(1000);
    }

    protected abstract MutableOutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    protected abstract void setOutTupleLeftFacts(MutableOutTuple_ var1, LeftTuple_ var2);

    protected abstract void setOutTupleRightFact(MutableOutTuple_ var1, UniTuple<Right_> var2);

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected final void insertOutTuple(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        MutableOutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
        TupleList outTupleListLeft = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftOutTupleList);
        TupleListEntry<MutableOutTuple_> outEntryLeft = outTupleListLeft.add(outTuple);
        outTuple.setStore(this.outputStoreIndexLeftOutEntry, outEntryLeft);
        TupleList outTupleListRight = (TupleList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
        TupleListEntry<MutableOutTuple_> outEntryRight = outTupleListRight.add(outTuple);
        outTuple.setStore(this.outputStoreIndexRightOutEntry, outEntryRight);
        this.dirtyTupleQueue.add(outTuple);
    }

    protected void updateOutTupleLeft(MutableOutTuple_ outTuple, LeftTuple_ leftTuple) {
        this.setOutTupleLeftFacts(outTuple, leftTuple);
        this.doUpdateOutTuple(outTuple);
    }

    protected void updateOutTupleRight(MutableOutTuple_ outTuple, UniTuple<Right_> rightTuple) {
        this.setOutTupleRightFact(outTuple, rightTuple);
        this.doUpdateOutTuple(outTuple);
    }

    private final void doUpdateOutTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.UPDATING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    protected final void retractOutTuple(MutableOutTuple_ outTuple) {
        TupleListEntry outEntryLeft = (TupleListEntry)outTuple.removeStore(this.outputStoreIndexLeftOutEntry);
        outEntryLeft.remove();
        TupleListEntry outEntryRight = (TupleListEntry)outTuple.removeStore(this.outputStoreIndexRightOutEntry);
        outEntryRight.remove();
        switch (outTuple.getState()) {
            case CREATING: {
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.DYING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            case UPDATING: {
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    @Override
    public final void calculateScore() {
        block6: for (Tuple tuple : this.dirtyTupleQueue) {
            switch (tuple.getState()) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(tuple);
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.getState() + ").");
        }
        this.dirtyTupleQueue.clear();
    }
}

