/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplelong;

import java.util.Objects;
import org.optaplanner.core.api.score.AbstractScore;

public final class SimpleLongScore
extends AbstractScore<SimpleLongScore> {
    public static final SimpleLongScore ZERO = new SimpleLongScore(0, 0L);
    public static final SimpleLongScore ONE = new SimpleLongScore(0, 1L);
    private final long score;

    public static SimpleLongScore parseScore(String scoreString) {
        String[] scoreTokens = SimpleLongScore.parseScoreTokens(SimpleLongScore.class, scoreString, "");
        int initScore = SimpleLongScore.parseInitScore(SimpleLongScore.class, scoreString, scoreTokens[0]);
        long score = SimpleLongScore.parseLevelAsLong(SimpleLongScore.class, scoreString, scoreTokens[1]);
        return SimpleLongScore.ofUninitialized(initScore, score);
    }

    public static SimpleLongScore ofUninitialized(int initScore, long score) {
        return new SimpleLongScore(initScore, score);
    }

    public static SimpleLongScore of(long score) {
        return new SimpleLongScore(0, score);
    }

    private SimpleLongScore() {
        this(Integer.MIN_VALUE, Long.MIN_VALUE);
    }

    private SimpleLongScore(int initScore, long score) {
        super(initScore);
        this.score = score;
    }

    public long getScore() {
        return this.score;
    }

    @Override
    public SimpleLongScore withInitScore(int newInitScore) {
        return new SimpleLongScore(newInitScore, this.score);
    }

    @Override
    public SimpleLongScore add(SimpleLongScore addend) {
        return new SimpleLongScore(this.initScore + addend.getInitScore(), this.score + addend.getScore());
    }

    @Override
    public SimpleLongScore subtract(SimpleLongScore subtrahend) {
        return new SimpleLongScore(this.initScore - subtrahend.getInitScore(), this.score - subtrahend.getScore());
    }

    @Override
    public SimpleLongScore multiply(double multiplicand) {
        return new SimpleLongScore((int)Math.floor((double)this.initScore * multiplicand), (long)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleLongScore divide(double divisor) {
        return new SimpleLongScore((int)Math.floor((double)this.initScore / divisor), (long)Math.floor((double)this.score / divisor));
    }

    @Override
    public SimpleLongScore power(double exponent) {
        return new SimpleLongScore((int)Math.floor(Math.pow(this.initScore, exponent)), (long)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public SimpleLongScore negate() {
        return new SimpleLongScore(-this.initScore, -this.score);
    }

    @Override
    public SimpleLongScore abs() {
        return new SimpleLongScore(Math.abs(this.initScore), Math.abs(this.score));
    }

    @Override
    public SimpleLongScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0;
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleLongScore) {
            SimpleLongScore other = (SimpleLongScore)o;
            return this.initScore == other.getInitScore() && this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.score);
    }

    @Override
    public int compareTo(SimpleLongScore other) {
        if (this.initScore != other.getInitScore()) {
            return Integer.compare(this.initScore, other.getInitScore());
        }
        return Long.compare(this.score, other.getScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> n.longValue() != 0L, "");
    }

    public String toString() {
        return this.getInitPrefix() + this.score;
    }
}

