/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.nextprev;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.optaplanner.core.api.domain.variable.PlanningListVariable;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.supply.Demand;

abstract class AbstractNextPrevElementShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    protected ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    AbstractNextPrevElementShadowVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    abstract String getSourceVariableName();

    abstract String getAnnotationName();

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.linkShadowSources(descriptorPolicy);
    }

    private void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        String sourceVariableName = this.getSourceVariableName();
        List entitiesWithSourceVariable = this.entityDescriptor.getSolutionDescriptor().getEntityDescriptors().stream().filter(entityDescriptor -> entityDescriptor.hasVariableDescriptor(sourceVariableName)).collect(Collectors.toList());
        if (entitiesWithSourceVariable.isEmpty()) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on any of the entity classes (" + this.entityDescriptor.getSolutionDescriptor().getEntityDescriptors() + ").");
        }
        if (entitiesWithSourceVariable.size() > 1) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a unique planning variable. A planning variable with the name (" + sourceVariableName + ") exists on multiple entity classes (" + entitiesWithSourceVariable + ").");
        }
        VariableDescriptor variableDescriptor = ((EntityDescriptor)entitiesWithSourceVariable.get(0)).getVariableDescriptor(sourceVariableName);
        if (variableDescriptor == null) {
            throw new IllegalStateException("Impossible state: variableDescriptor (" + variableDescriptor + ") is null but previous checks indicate that the entityClass (" + entitiesWithSourceVariable.get(0) + ") has a planning variable with sourceVariableName (" + sourceVariableName + ").");
        }
        if (!(variableDescriptor instanceof ListVariableDescriptor)) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a @" + PlanningListVariable.class.getSimpleName() + ".");
        }
        this.sourceVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
        if (!this.variableMemberAccessor.getType().equals(this.sourceVariableDescriptor.getElementType())) {
            throw new IllegalStateException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + this.getAnnotationName() + " annotated property (" + this.variableMemberAccessor.getName() + ") of type (" + this.variableMemberAccessor.getType() + ") which is not the type of elements (" + this.sourceVariableDescriptor.getElementType() + ") of the source list variable (" + this.sourceVariableDescriptor + ").");
        }
        this.sourceVariableDescriptor.registerSinkVariableDescriptor(this);
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return Collections.singletonList(this.sourceVariableDescriptor);
    }

    @Override
    public Demand<?> getProvidedDemand() {
        throw new UnsupportedOperationException("Not implemented because no subsystems demand previous or next shadow variables.");
    }
}

