/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListChangeMoveIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.TriangularNumbers;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;

public class RandomSubListChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntitySelector<Solution_> entitySelector;
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final int minimumSubListSize;
    private final int maximumSubListSize;
    private final boolean selectReversingMoveToo;
    private final RandomSubListSelector<Solution_> subListSelector;

    public RandomSubListChangeMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, EntitySelector<Solution_> entitySelector, EntityIndependentValueSelector<Solution_> valueSelector, int minimumSubListSize, int maximumSubListSize, boolean selectReversingMoveToo) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.minimumSubListSize = minimumSubListSize;
        this.maximumSubListSize = maximumSubListSize;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.subListSelector = new RandomSubListSelector<Solution_>(listVariableDescriptor, entitySelector, valueSelector, minimumSubListSize, maximumSubListSize);
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
        this.phaseLifecycleSupport.addEventListener(this.subListSelector);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new RandomSubListChangeMoveIterator<Solution_>(this.listVariableDescriptor, this.subListSelector, this.entitySelector, this.workingRandom, this.selectReversingMoveToo);
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long destinationRange = this.entitySelector.getSize() + this.valueSelector.getSize();
        long subListCount = 0L;
        for (Object entity : this.entitySelector::endingIterator) {
            int listSize = this.listVariableDescriptor.getListSize(entity);
            if (listSize < this.minimumSubListSize) continue;
            subListCount += (long)TriangularNumbers.nthTriangle(listSize - this.minimumSubListSize + 1);
            if (listSize <= this.maximumSubListSize) continue;
            subListCount -= (long)TriangularNumbers.nthTriangle(listSize - this.maximumSubListSize);
        }
        return subListCount * destinationRange;
    }

    boolean isSelectReversingMoveToo() {
        return this.selectReversingMoveToo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subListSelector + ")";
    }
}

