/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.DecimalEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.MaxWeight;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMMaxWeightParser
implements TagParser {
    private static Logger LOG = LoggerFactory.getLogger(OSMMaxWeightParser.class);
    private final DecimalEncodedValue weightEncoder;
    private final boolean enableLog;

    public OSMMaxWeightParser() {
        this(MaxWeight.create(), false);
    }

    public OSMMaxWeightParser(DecimalEncodedValue weightEncoder, boolean enableLog) {
        this.weightEncoder = weightEncoder;
        this.enableLog = enableLog;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.weightEncoder);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        List<String> weightTags = Arrays.asList("maxweight", "maxgcweight");
        OSMMaxWeightParser.extractTons(edgeFlags, way, this.weightEncoder, weightTags, this.enableLog);
        return edgeFlags;
    }

    static void extractTons(IntsRef edgeFlags, ReaderWay way, DecimalEncodedValue valueEncoder, List<String> keys, boolean enableLog) {
        block4: {
            String value = way.getFirstPriorityTag(keys);
            if (Helper.isEmpty((String)value)) {
                return;
            }
            try {
                double val = OSMMaxWeightParser.stringToTons(value);
                if (val > valueEncoder.getMaxDecimal()) {
                    val = valueEncoder.getMaxDecimal();
                }
                valueEncoder.setDecimal(false, edgeFlags, val);
            }
            catch (Exception ex) {
                if (!enableLog) break block4;
                LOG.warn("Unable to extract tons from malformed road attribute '{}' for way (OSM_ID = {}).", (Object)value, (Object)way.getId());
            }
        }
    }

    public static double stringToTons(String value) {
        value = Helper.toLowerCase((String)value).replaceAll(" ", "").replaceAll("(tons|ton)", "t");
        value = value.replace("mgw", "").trim();
        double factor = 1.0;
        if (value.equals("default") || value.equals("none")) {
            return -1.0;
        }
        if (value.endsWith("t")) {
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("lbs")) {
            value = value.substring(0, value.length() - 3);
            factor = 4.5359237E-4;
        }
        return Double.parseDouble(value) * factor;
    }
}

