/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.storage.index.PointEmitter;

public class BresenhamLine {
    public static void calcPoints(int y1, int x1, int y2, int x2, PointEmitter emitter) {
        BresenhamLine.bresenham(y1, x1, y2, x2, emitter);
    }

    public static void bresenham(int y1, int x1, int y2, int x2, PointEmitter emitter) {
        boolean latIncreasing = y1 < y2;
        boolean lonIncreasing = x1 < x2;
        int dLat = Math.abs(y2 - y1);
        int sLat = latIncreasing ? 1 : -1;
        int dLon = Math.abs(x2 - x1);
        int sLon = lonIncreasing ? 1 : -1;
        int err = dLon - dLat;
        while (true) {
            emitter.set(y1, x1);
            if (y1 == y2 && x1 == x2) break;
            int tmpErr = 2 * err;
            if (tmpErr > -dLat) {
                err -= dLat;
                x1 += sLon;
            }
            if (tmpErr >= dLon) continue;
            err += dLon;
            y1 += sLat;
        }
    }

    public static void calcPoints(double lat1, double lon1, double lat2, double lon2, final PointEmitter emitter, final double offsetLat, final double offsetLon, final double deltaLat, final double deltaLon) {
        int y1 = (int)((lat1 - offsetLat) / deltaLat);
        int x1 = (int)((lon1 - offsetLon) / deltaLon);
        int y2 = (int)((lat2 - offsetLat) / deltaLat);
        int x2 = (int)((lon2 - offsetLon) / deltaLon);
        BresenhamLine.bresenham(y1, x1, y2, x2, new PointEmitter(){

            @Override
            public void set(double lat, double lon) {
                emitter.set((lat + 0.1) * deltaLat + offsetLat, (lon + 0.1) * deltaLon + offsetLon);
            }
        });
    }
}

