/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.optaweb.vehiclerouting.service.demo.DemoService;

@Path(value="api/dataset/export")
@Produces(value={"text/x-yaml"})
public class DataSetDownloadResource {
    private final DemoService demoService;

    public DataSetDownloadResource() {
    }

    DataSetDownloadResource(DemoService demoService) {
        this.demoService = demoService;
    }

    @GET
    public Response exportDataSet() throws IOException {
        String dataSet = this.demoService.exportDataSet();
        byte[] dataSetBytes = dataSet.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream is = new ByteArrayInputStream(dataSetBytes);){
            Response response = Response.ok().header("Content-Disposition", (Object)"attachment; filename=\"vrp_data_set.yaml\"").header("Content-Length", (Object)dataSetBytes.length).type(new MediaType("text", "x-yaml", StandardCharsets.UTF_8.name())).entity((Object)is).build();
            return response;
        }
    }
}

