/*
 * Decompiled with CFR 0.152.
 */
package org.drools.statics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticKieAssemblers
implements KieAssemblers {
    private static final Logger log = LoggerFactory.getLogger(StaticKieAssemblers.class);
    private Map<ResourceType, KieAssemblerService> assemblers = new HashMap<ResourceType, KieAssemblerService>();

    public void addResourceBeforeRules(Object knowledgeBuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        KieAssemblerService assembler = this.assemblers.get(type);
        if (assembler == null) {
            throw new RuntimeException("Unknown resource type: " + type);
        }
        assembler.addResourceBeforeRules(knowledgeBuilder, resource, type, configuration);
    }

    public void addResourceAfterRules(Object knowledgeBuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        KieAssemblerService assembler = this.assemblers.get(type);
        if (assembler != null) {
            assembler.addResourceAfterRules(knowledgeBuilder, resource, type, configuration);
        } else {
            log.debug("KieAssemblers: ignored {}", (Object)type);
        }
    }

    public void addResourcesAfterRules(Object knowledgeBuilder, List<ResourceWithConfiguration> resources, ResourceType type) throws Exception {
        KieAssemblerService assembler = this.assemblers.get(type);
        if (assembler != null) {
            assembler.addResourcesAfterRules(knowledgeBuilder, resources, type);
        } else {
            log.debug("KieAssemblers: ignored {}", (Object)type);
        }
    }
}

