/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoft;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScoreHolder;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;

public final class HardMediumSoftScoreHolderImpl
extends AbstractScoreHolder<HardMediumSoftScore>
implements HardMediumSoftScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.IntMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.IntMatchExecutor>();
    protected final Map<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftScore>>();
    protected int hardScore;
    protected int mediumScore;
    protected int softScore;

    public HardMediumSoftScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftScore.ZERO);
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getMediumScore() {
        return this.mediumScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardMediumSoftScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        AbstractScoreHolder.IntMatchExecutor matchExecutor = constraintWeight.equals(HardMediumSoftScore.ZERO) ? (kcontext, weightMultiplier, justifications) -> {} : (constraintWeight.getMediumScore() == 0 && constraintWeight.getSoftScore() == 0 ? (kcontext, weightMultiplier, justifications) -> this.addHardConstraintMatch(kcontext, constraintWeight.getHardScore() * weightMultiplier, justifications) : (constraintWeight.getHardScore() == 0 && constraintWeight.getSoftScore() == 0 ? (kcontext, weightMultiplier, justifications) -> this.addMediumConstraintMatch(kcontext, constraintWeight.getMediumScore() * weightMultiplier, justifications) : (constraintWeight.getHardScore() == 0 && constraintWeight.getMediumScore() == 0 ? (kcontext, weightMultiplier, justifications) -> this.addSoftConstraintMatch(kcontext, constraintWeight.getSoftScore() * weightMultiplier, justifications) : (kcontext, weightMultiplier, justifications) -> this.addMultiConstraintMatch(kcontext, constraintWeight.getHardScore() * weightMultiplier, constraintWeight.getMediumScore() * weightMultiplier, constraintWeight.getSoftScore() * weightMultiplier, justifications))));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch(kcontext, constraintWeight.getHardScore() * weightMultiplier.getHardScore(), constraintWeight.getMediumScore() * weightMultiplier.getMediumScore(), constraintWeight.getSoftScore() * weightMultiplier.getSoftScore()));
    }

    @Override
    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1);
    }

    @Override
    public void penalize(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    @Override
    public void penalize(RuleContext kcontext, int hardWeightMultiplier, int mediumWeightMultiplier, int softWeightMultiplier) {
        this.impactScore(kcontext, -hardWeightMultiplier, -mediumWeightMultiplier, -softWeightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    @Override
    public void reward(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void reward(RuleContext kcontext, int hardWeightMultiplier, int mediumWeightMultiplier, int softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext, Object ... justifications) {
        this.impactScore(kcontext, 1, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier, Object ... justifications) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.IntMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier, justifications);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier, Object ... justifications) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a long weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeLong() to penalize().");
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier, Object ... justifications) {
        throw new UnsupportedOperationException("In the rule (" + kcontext.getRule().getName() + "), the scoreHolder class (" + this.getClass() + ") does not support a BigDecimal weightMultiplier (" + weightMultiplier + ").\nIf you're using constraint streams, maybe switch from penalizeBigDecimal() to penalize().");
    }

    private void impactScore(RuleContext kcontext, int hardWeightMultiplier, int mediumWeightMultiplier, int softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardMediumSoftScore.of(hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier));
    }

    @Override
    public void addHardConstraintMatch(RuleContext kcontext, int hardWeight) {
        this.addHardConstraintMatch(kcontext, hardWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addHardConstraintMatch(RuleContext kcontext, int hardWeight, Object ... justifications) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardMediumSoftScore.ofHard(hardWeight), justifications);
    }

    @Override
    public void addMediumConstraintMatch(RuleContext kcontext, int mediumWeight) {
        this.addMediumConstraintMatch(kcontext, mediumWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addMediumConstraintMatch(RuleContext kcontext, int mediumWeight, Object ... justifications) {
        this.mediumScore += mediumWeight;
        this.registerConstraintMatch(kcontext, () -> this.mediumScore -= mediumWeight, () -> HardMediumSoftScore.ofMedium(mediumWeight), justifications);
    }

    @Override
    public void addSoftConstraintMatch(RuleContext kcontext, int softWeight) {
        this.addSoftConstraintMatch(kcontext, softWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addSoftConstraintMatch(RuleContext kcontext, int softWeight, Object ... justifications) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardMediumSoftScore.ofSoft(softWeight), justifications);
    }

    @Override
    public void addMultiConstraintMatch(RuleContext kcontext, int hardWeight, int mediumWeight, int softWeight) {
        this.addMultiConstraintMatch(kcontext, hardWeight, mediumWeight, softWeight, EMPTY_OBJECT_ARRAY);
    }

    private void addMultiConstraintMatch(RuleContext kcontext, int hardWeight, int mediumWeight, int softWeight, Object ... justifications) {
        this.hardScore += hardWeight;
        this.mediumScore += mediumWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.mediumScore -= mediumWeight;
            this.softScore -= softWeight;
        }, () -> HardMediumSoftScore.of(hardWeight, mediumWeight, softWeight), justifications);
    }

    @Override
    public HardMediumSoftScore extractScore(int initScore) {
        return HardMediumSoftScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }
}

