/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.core.util.ClassUtils;
import org.drools.mvel.parser.ast.expr.DrlNameExpr;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvel.parser.printer.PrintUtil;
import org.drools.mvelcompiler.MvelCompilerException;
import org.drools.mvelcompiler.ast.AssignExprT;
import org.drools.mvelcompiler.ast.BigDecimalArithmeticExprT;
import org.drools.mvelcompiler.ast.BigDecimalConvertedExprT;
import org.drools.mvelcompiler.ast.BlockStmtT;
import org.drools.mvelcompiler.ast.ExpressionStmtT;
import org.drools.mvelcompiler.ast.FieldToAccessorTExpr;
import org.drools.mvelcompiler.ast.ForEachDowncastStmtT;
import org.drools.mvelcompiler.ast.ListAccessExprT;
import org.drools.mvelcompiler.ast.MapPutExprT;
import org.drools.mvelcompiler.ast.SimpleNameTExpr;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.ast.UnalteredTypedExpression;
import org.drools.mvelcompiler.ast.VariableDeclaratorTExpr;
import org.drools.mvelcompiler.context.Declaration;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.drools.mvelcompiler.util.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHSPhase
implements DrlGenericVisitor<TypedExpression, Void> {
    private Logger logger = LoggerFactory.getLogger(LHSPhase.class);
    private final MvelCompilerContext mvelCompilerContext;
    private final Optional<TypedExpression> rhs;

    public LHSPhase(MvelCompilerContext mvelCompilerContext, Optional<TypedExpression> rhs) {
        this.mvelCompilerContext = mvelCompilerContext;
        this.rhs = rhs;
    }

    public TypedExpression invoke(Node n) {
        this.logPhase("LHS phase on: {}", n);
        TypedExpression typedExpression = (TypedExpression)n.accept((GenericVisitor)this, null);
        if (typedExpression == null) {
            throw new MvelCompilerException("Type check of " + PrintUtil.printConstraint((Node)n) + " failed.");
        }
        this.logger.debug("LHS phase completed");
        return typedExpression;
    }

    public TypedExpression visit(DrlNameExpr n, Void arg) {
        this.logPhase("DrlNameExpr {}", (Node)n);
        String variableName = PrintUtil.printConstraint((Node)n);
        Optional<Declaration> declaration = this.mvelCompilerContext.findDeclarations(variableName);
        return declaration.map(d -> new SimpleNameTExpr(n.getNameAsString(), d.getClazz())).orElseGet(() -> {
            this.mvelCompilerContext.addCreatedDeclaration(variableName, this.getRHSType());
            return new VariableDeclaratorTExpr((Node)n, variableName, this.getRHSType(), this.rhs);
        });
    }

    public TypedExpression visit(FieldAccessExpr n, Void arg) {
        this.logPhase("FieldAccessExpr {}", (Node)n);
        if (this.parentIsExpressionStmt((Node)n)) {
            return this.rhsOrError();
        }
        TypedExpression fieldAccessScope = (TypedExpression)n.getScope().accept((GenericVisitor)this, (Object)arg);
        n.getName().accept((GenericVisitor)this, (Object)arg);
        if (this.parentIsArrayAccessExpr((Node)n)) {
            return this.tryParseItAsMap(n, fieldAccessScope).map(Optional::of).orElseGet(() -> this.tryParseItAsSetter(n, fieldAccessScope, this.getRHSType())).orElse(new UnalteredTypedExpression((Node)n));
        }
        return this.tryParseAsBigDecimalArithmeticExpression(n, fieldAccessScope).map(Optional::of).orElseGet(() -> this.tryParseItAsSetter(n, fieldAccessScope, this.getRHSType())).orElse(new UnalteredTypedExpression((Node)n));
    }

    public Optional<TypedExpression> withBigDecimalConversion(AssignExpr assignExpr, TypedExpression target, TypedExpression value) {
        Optional<Type> optRHSType = value.getType();
        if (!optRHSType.isPresent()) {
            return Optional.empty();
        }
        AssignExpr.Operator operator = assignExpr.getOperator();
        if (operator == AssignExpr.Operator.ASSIGN) {
            return Optional.empty();
        }
        boolean assigningToFieldAccess = target instanceof FieldToAccessorTExpr;
        if (!assigningToFieldAccess && target.getType().filter(t -> t == BigDecimal.class).isPresent()) {
            String bigDecimalMethod = BigDecimalArithmeticExprT.toBigDecimalMethod(operator);
            BigDecimalArithmeticExprT convertedBigDecimalExpr = new BigDecimalArithmeticExprT(bigDecimalMethod, target, value);
            return Optional.of(new AssignExprT(AssignExpr.Operator.ASSIGN, target, convertedBigDecimalExpr));
        }
        return Optional.empty();
    }

    private Optional<TypedExpression> tryParseAsBigDecimalArithmeticExpression(FieldAccessExpr n, TypedExpression scope) {
        Optional<Node> optParentAssignExpr = n.getParentNode().filter(p -> p instanceof AssignExpr);
        String setterName = PrintUtil.printConstraint((Node)n.getName());
        return optParentAssignExpr.flatMap(parentAssignExpr -> this.findAccessorsAndConvert(scope, setterName, (AssignExpr)parentAssignExpr));
    }

    private Optional<TypedExpression> findAccessorsAndConvert(TypedExpression fieldAccessScope, String accessorName, AssignExpr parentAssignExpr) {
        Class scopeType = (Class)fieldAccessScope.getType().orElseThrow(() -> new MvelCompilerException("Scope without a type"));
        Optional<Method> optSetter = Optional.ofNullable(ClassUtils.getSetter((Class)scopeType, (String)accessorName, BigDecimal.class));
        AssignExpr.Operator parentOperator = parentAssignExpr.getOperator();
        return optSetter.map(setter -> {
            if (parentOperator.equals((Object)AssignExpr.Operator.ASSIGN)) {
                return new FieldToAccessorTExpr(fieldAccessScope, (Method)setter, Collections.singletonList(this.rhsOrError()));
            }
            return this.bigDecimalCompoundOperator(fieldAccessScope, accessorName, scopeType, parentOperator, (Method)setter);
        });
    }

    private FieldToAccessorTExpr bigDecimalCompoundOperator(TypedExpression fieldAccessScope, String accessorName, Class<?> scopeType, AssignExpr.Operator parentOperator, Method setter) {
        String bigDecimalArithmeticMethod = BigDecimalArithmeticExprT.toBigDecimalMethod(parentOperator);
        Method optGetter = Optional.ofNullable(ClassUtils.getAccessor(scopeType, (String)accessorName)).orElseThrow(() -> new MvelCompilerException("No getter found but setter is present for accessor: " + accessorName));
        FieldToAccessorTExpr getterExpression = new FieldToAccessorTExpr(fieldAccessScope, optGetter, Collections.emptyList());
        TypedExpression argument = this.rhsOrError();
        if (argument.getType().filter(t -> t != BigDecimal.class).isPresent()) {
            argument = new BigDecimalConvertedExprT(argument);
        }
        BigDecimalArithmeticExprT bigDecimalArithmeticExprT = new BigDecimalArithmeticExprT(bigDecimalArithmeticMethod, getterExpression, argument);
        return new FieldToAccessorTExpr(fieldAccessScope, setter, Collections.singletonList(bigDecimalArithmeticExprT));
    }

    private Optional<TypedExpression> tryParseItAsMap(FieldAccessExpr n, TypedExpression scope) {
        return scope.getType().flatMap(scopeType -> {
            String getterName = PrintUtil.printConstraint((Node)n.getName());
            return Optional.ofNullable(ClassUtils.getAccessor((Class)((Class)scopeType), (String)getterName)).filter(t -> Map.class.isAssignableFrom(t.getReturnType())).map(accessor -> new FieldToAccessorTExpr(scope, (Method)accessor, Collections.emptyList()));
        });
    }

    private Optional<TypedExpression> tryParseItAsSetter(FieldAccessExpr n, TypedExpression scope, Class<?> setterArgumentType) {
        return scope.getType().flatMap(scopeType -> {
            String setterName = PrintUtil.printConstraint((Node)n.getName());
            Optional<Method> optAccessor = Optional.ofNullable(ClassUtils.getSetter((Class)((Class)scopeType), (String)setterName, (Class)setterArgumentType));
            List arguments = this.rhs.map(Collections::singletonList).orElse(Collections.emptyList());
            return optAccessor.map(accessor -> new FieldToAccessorTExpr(scope, (Method)accessor, arguments));
        });
    }

    public TypedExpression visit(MethodCallExpr n, Void arg) {
        this.logPhase("MethodCallExpr {}", (Node)n);
        return this.rhsOrError();
    }

    public TypedExpression visit(VariableDeclarationExpr n, Void arg) {
        this.logPhase("VariableDeclarationExpr {}", (Node)n);
        return (TypedExpression)((VariableDeclarator)n.getVariables().iterator().next()).accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(VariableDeclarator n, Void arg) {
        this.logPhase("VariableDeclarator {}", (Node)n);
        String variableName = n.getName().asString();
        Class<?> type = this.getRHSorLHSType(n);
        this.mvelCompilerContext.addDeclaration(variableName, type);
        return new VariableDeclaratorTExpr((Node)n, variableName, type, this.rhs);
    }

    public TypedExpression visit(ExpressionStmt n, Void arg) {
        this.logPhase("ExpressionStmt {}", (Node)n);
        Optional<Object> expression = Optional.ofNullable(n.getExpression().accept((GenericVisitor)this, (Object)arg));
        return new ExpressionStmtT(expression.orElseGet(this::rhsOrError));
    }

    public TypedExpression visit(EnclosedExpr n, Void arg) {
        return (TypedExpression)n.getInner().accept((GenericVisitor)this, (Object)arg);
    }

    public TypedExpression visit(AssignExpr n, Void arg) {
        this.logPhase("AssignExpr {}", (Node)n);
        TypedExpression target = (TypedExpression)n.getTarget().accept((GenericVisitor)this, (Object)arg);
        Optional<TypedExpression> bigDecimalConversion = this.withBigDecimalConversion(n, target, this.rhsOrError());
        if (bigDecimalConversion.isPresent()) {
            return bigDecimalConversion.get();
        }
        if (target instanceof FieldToAccessorTExpr || target instanceof VariableDeclaratorTExpr || target instanceof MapPutExprT) {
            return target;
        }
        return new AssignExprT(n.getOperator(), target, this.rhsOrNull());
    }

    public TypedExpression visit(ArrayAccessExpr n, Void arg) {
        if (this.parentIsExpressionStmt((Node)n)) {
            return this.rhsOrError();
        }
        TypedExpression name = (TypedExpression)n.getName().accept((GenericVisitor)this, (Object)arg);
        Optional<Type> type = name.getType();
        if (type.filter(TypeUtils::isCollection).isPresent()) {
            Expression index = n.getIndex();
            if (index.isStringLiteralExpr() || index.isNameExpr()) {
                return new MapPutExprT(name, index, this.rhsOrNull(), name.getType());
            }
            return new ListAccessExprT(name, index, type.get());
        }
        return new UnalteredTypedExpression((Node)n, type.orElse(null));
    }

    public TypedExpression visit(IfStmt n, Void arg) {
        return new UnalteredTypedExpression((Node)n);
    }

    public TypedExpression visit(ForEachStmt n, Void arg) {
        Expression iterable = n.getIterable();
        if (iterable.isNameExpr()) {
            return this.mvelCompilerContext.findDeclarations(iterable.asNameExpr().toString()).filter(this::isDeclarationIterable).map(d -> {
                TypedExpression child = this.visit((BlockStmt)n.getBody(), arg);
                return new ForEachDowncastStmtT(n.getVariable(), n.getIterable().asNameExpr().toString(), child);
            }).orElse(new UnalteredTypedExpression((Node)n));
        }
        return new UnalteredTypedExpression((Node)n);
    }

    public TypedExpression visit(BlockStmt n, Void arg) {
        ArrayList<TypedExpression> statements = new ArrayList<TypedExpression>();
        for (Statement s : n.getStatements()) {
            TypedExpression visit = s.isForEachStmt() ? this.visit((ForEachStmt)s, arg) : this.defaultMethod((Node)s, arg);
            statements.add(visit);
        }
        return new BlockStmtT(statements);
    }

    private boolean isDeclarationIterable(Declaration declaration) {
        Class<?> declarationClazz = declaration.getClazz();
        return Iterable.class.isAssignableFrom(declarationClazz);
    }

    private TypedExpression rhsOrNull() {
        return this.rhs.orElse(null);
    }

    private TypedExpression rhsOrError() {
        return this.rhs.orElseThrow(() -> new MvelCompilerException("RHS not found, need a valid expression"));
    }

    private boolean parentIsExpressionStmt(Node n) {
        return n.getParentNode().filter(p -> p instanceof ExpressionStmt).isPresent();
    }

    private boolean parentIsArrayAccessExpr(Node n) {
        return n.getParentNode().filter(p -> p instanceof ArrayAccessExpr).isPresent();
    }

    private Class<?> getRHSType() {
        return this.rhs.flatMap(TypedExpression::getType).map(TypeUtils::classFromType).orElseThrow(() -> new MvelCompilerException("RHS doesn't have a type"));
    }

    private Class<?> getRHSorLHSType(VariableDeclarator n) {
        return this.mvelCompilerContext.resolveType(n.getType().asString());
    }

    private void logPhase(String phase, Node statement) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(phase, (Object)PrintUtil.printConstraint((Node)statement));
        }
    }

    public TypedExpression defaultMethod(Node n, Void unused) {
        return new UnalteredTypedExpression(n);
    }
}

