/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.Contextualized;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class CompletableFutureWrapper<T>
extends CompletableFuture<T>
implements Contextualized {
    protected final CompletableFuture<T> f;
    protected final SmallRyeThreadContext context;
    protected final Executor executor;
    protected final int flags;
    public static final int FLAG_MINIMAL = 1;
    public static final int FLAG_DEPENDENT = 2;

    public CompletableFutureWrapper(SmallRyeThreadContext context, CompletableFuture<T> f, Executor executor, int flags) {
        this.context = context;
        this.f = f;
        f.whenComplete((T r, U t) -> {
            if (t != null) {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                super.completeExceptionally((Throwable)t);
            } else {
                super.complete(r);
            }
        });
        this.executor = executor;
        this.flags = flags;
    }

    private void checkDefaultExecutor() {
        if (this.executor == null) {
            throw new UnsupportedOperationException("Async methods not supported when no executor is specified");
        }
    }

    private void checkMinimal() {
        if ((this.flags & 1) != 0) {
            throw new UnsupportedOperationException("Completion methods not supported for minimal CompletionStage instances");
        }
    }

    private boolean isDependent() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean complete(T value) {
        this.checkMinimal();
        if (this.isDependent()) {
            return super.complete(value);
        }
        return this.f.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.checkMinimal();
        if (this.isDependent()) {
            return super.completeExceptionally(ex);
        }
        return this.f.completeExceptionally(ex);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDependent()) {
            return super.cancel(mayInterruptIfRunning);
        }
        return this.f.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        if (this.isDependent()) {
            return super.isCancelled();
        }
        return this.f.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        if (this.isDependent()) {
            return super.isCompletedExceptionally();
        }
        return this.f.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(T value) {
        if (this.isDependent()) {
            super.obtrudeValue(value);
        } else {
            this.f.obtrudeValue(value);
        }
    }

    @Override
    public void obtrudeException(Throwable ex) {
        if (this.isDependent()) {
            super.obtrudeException(ex);
        } else {
            this.f.obtrudeException(ex);
        }
    }

    @Override
    public int getNumberOfDependents() {
        if (this.isDependent()) {
            return super.getNumberOfDependents();
        }
        return this.f.getNumberOfDependents();
    }

    @Override
    public boolean isDone() {
        if (this.isDependent()) {
            return super.isDone();
        }
        return this.f.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.isDependent()) {
            return super.get();
        }
        return this.f.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isDependent()) {
            return super.get(timeout, unit);
        }
        return this.f.get(timeout, unit);
    }

    @Override
    public T join() {
        if (this.isDependent()) {
            return super.join();
        }
        return this.f.join();
    }

    @Override
    public T getNow(T valueIfAbsent) {
        if (this.isDependent()) {
            return super.getNow(valueIfAbsent);
        }
        return this.f.getNow(valueIfAbsent);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.context.withContextCapture(this.f.exceptionally(this.context.contextualFunctionUnlessContextualized(fn)), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.context.withContextCapture(this.f.handle(this.context.contextualFunctionUnlessContextualized(fn)), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.handleAsync(this.context.contextualFunctionUnlessContextualized(fn), this.executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.context.withContextCapture(this.f.handleAsync(this.context.contextualFunctionUnlessContextualized(fn), executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.context.withContextCapture(this.f.thenApply(this.context.contextualFunctionUnlessContextualized(fn)), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenApplyAsync(this.context.contextualFunctionUnlessContextualized(fn), this.executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.context.withContextCapture(this.f.thenApplyAsync(this.context.contextualFunctionUnlessContextualized(fn), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.context.withContextCapture(this.f.thenAccept((Consumer)this.context.contextualConsumerUnlessContextualized(action)), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenAcceptAsync((Consumer)this.context.contextualConsumerUnlessContextualized(action), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.context.withContextCapture(this.f.thenAcceptAsync((Consumer)this.context.contextualConsumerUnlessContextualized(action), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.context.withContextCapture(this.f.thenRun(this.context.contextualRunnableUnlessContextualized(action)), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenRunAsync(this.context.contextualRunnableUnlessContextualized(action), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.context.withContextCapture(this.f.thenRunAsync(this.context.contextualRunnableUnlessContextualized(action), executor), this.executor, this.flags);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.context.withContextCapture(this.f.thenCombine(other, this.context.contextualFunctionUnlessContextualized(fn)), this.executor, this.flags);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenCombineAsync(other, this.context.contextualFunctionUnlessContextualized(fn), this.executor), this.executor, this.flags);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.context.withContextCapture(this.f.thenCombineAsync(other, this.context.contextualFunctionUnlessContextualized(fn), executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.context.withContextCapture(this.f.thenAcceptBoth(other, (BiConsumer)this.context.contextualConsumerUnlessContextualized(action)), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenAcceptBothAsync(other, (BiConsumer)this.context.contextualConsumerUnlessContextualized(action), this.executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.context.withContextCapture(this.f.thenAcceptBothAsync(other, (BiConsumer)this.context.contextualConsumerUnlessContextualized(action), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.context.withContextCapture(this.f.runAfterBoth((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action)), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.runAfterBothAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.context.withContextCapture(this.f.runAfterBothAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.context.withContextCapture(this.f.applyToEither((CompletionStage)other, this.context.contextualFunctionUnlessContextualized(fn)), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.applyToEitherAsync((CompletionStage)other, this.context.contextualFunctionUnlessContextualized(fn), this.executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.context.withContextCapture(this.f.applyToEitherAsync((CompletionStage)other, this.context.contextualFunctionUnlessContextualized(fn), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.context.withContextCapture(this.f.acceptEither((CompletionStage)other, (Consumer)this.context.contextualConsumerUnlessContextualized(action)), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.acceptEitherAsync((CompletionStage)other, (Consumer)this.context.contextualConsumerUnlessContextualized(action), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.context.withContextCapture(this.f.acceptEitherAsync((CompletionStage)other, (Consumer)this.context.contextualConsumerUnlessContextualized(action), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.context.withContextCapture(this.f.runAfterEither((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action)), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.runAfterEitherAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.context.withContextCapture(this.f.runAfterEitherAsync((CompletionStage)other, this.context.contextualRunnableUnlessContextualized(action), executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.context.withContextCapture(this.f.thenCompose(this.context.contextualFunctionUnlessContextualized(fn)), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenComposeAsync(this.context.contextualFunctionUnlessContextualized(fn), this.executor), this.executor, this.flags);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.context.withContextCapture(this.f.thenComposeAsync(this.context.contextualFunctionUnlessContextualized(fn), executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.context.withContextCapture(this.f.whenComplete(this.context.contextualConsumerUnlessContextualized(action)), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.whenCompleteAsync(this.context.contextualConsumerUnlessContextualized(action), this.executor), this.executor, this.flags);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.context.withContextCapture(this.f.whenCompleteAsync(this.context.contextualConsumerUnlessContextualized(action), executor), this.executor, this.flags);
    }

    @Override
    public String toString() {
        return this.f.toString();
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public boolean equals(Object obj) {
        return this.f.equals(obj);
    }
}

