/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.util.BitUtil;
import java.util.Comparator;
import java.util.TreeMap;

public class GHTreeMapComposed {
    private static final Integer NOT_EMPTY = -3;
    private final BitUtil bitUtil = BitUtil.BIG;
    private final TreeMap<Long, Integer> map = new TreeMap(new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            int value2;
            if (o1.equals(o2)) {
                return 0;
            }
            int value1 = GHTreeMapComposed.this.bitUtil.getIntHigh(o1);
            if (value1 == (value2 = GHTreeMapComposed.this.bitUtil.getIntHigh(o2))) {
                int key2;
                int key1 = GHTreeMapComposed.this.bitUtil.getIntLow(o1);
                if (key1 == (key2 = GHTreeMapComposed.this.bitUtil.getIntLow(o2))) {
                    return 0;
                }
                return key1 < key2 ? -1 : 1;
            }
            float f1 = Float.intBitsToFloat(value1);
            float f2 = Float.intBitsToFloat(value2);
            return Float.compare(f1, f2);
        }
    });

    public void clear() {
        this.map.clear();
    }

    void remove(int key, float value) {
        long v = this.bitUtil.toLong(Float.floatToRawIntBits(value), key);
        Integer prev = this.map.remove(v);
        if (prev == null) {
            throw new IllegalStateException("cannot remove key " + key + " with value " + value + " - did you insert this key with this value before ?");
        }
    }

    public void update(int key, float oldValue, float value) {
        this.remove(key, oldValue);
        this.insert(key, value);
    }

    public void insert(int key, float value) {
        long v = this.bitUtil.toLong(Float.floatToRawIntBits(value), key);
        this.map.put(v, NOT_EMPTY);
    }

    public float peekValue() {
        long key = this.map.firstEntry().getKey();
        return Float.intBitsToFloat(this.bitUtil.getIntHigh(key));
    }

    public int peekKey() {
        long key = this.map.firstEntry().getKey();
        return this.bitUtil.getIntLow(key);
    }

    public int pollKey() {
        if (this.map.isEmpty()) {
            throw new IllegalStateException("Cannot poll collection is empty!");
        }
        long key = this.map.pollFirstEntry().getKey();
        return this.bitUtil.getIntLow(key);
    }

    public int getSize() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.map.toString();
    }
}

