/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.PMap;

public class AlgorithmOptions {
    private final PMap hints = new PMap(5);
    private String algorithm = "dijkstrabi";
    private Weighting weighting;
    private TraversalMode traversalMode = TraversalMode.NODE_BASED;
    private int maxVisitedNodes = Integer.MAX_VALUE;

    private AlgorithmOptions() {
    }

    public AlgorithmOptions(String algorithm, Weighting weighting) {
        this.algorithm = algorithm;
        this.weighting = weighting;
    }

    public AlgorithmOptions(String algorithm, Weighting weighting, TraversalMode tMode) {
        this.algorithm = algorithm;
        this.weighting = weighting;
        this.traversalMode = tMode;
    }

    public static Builder start() {
        return new Builder();
    }

    public static Builder start(AlgorithmOptions opts) {
        Builder b = new Builder();
        if (opts.algorithm != null) {
            b.algorithm(opts.getAlgorithm());
        }
        if (opts.traversalMode != null) {
            b.traversalMode(opts.getTraversalMode());
        }
        if (opts.weighting != null) {
            b.weighting(opts.getWeighting());
        }
        if (opts.maxVisitedNodes >= 0) {
            b.maxVisitedNodes(opts.maxVisitedNodes);
        }
        if (!opts.hints.isEmpty()) {
            b.hints(opts.hints);
        }
        return b;
    }

    public TraversalMode getTraversalMode() {
        return this.traversalMode;
    }

    public boolean hasWeighting() {
        return this.weighting != null;
    }

    public Weighting getWeighting() {
        this.assertNotNull(this.weighting, "weighting");
        return this.weighting;
    }

    public String getAlgorithm() {
        this.assertNotNull(this.algorithm, "algorithm");
        return this.algorithm;
    }

    public int getMaxVisitedNodes() {
        return this.maxVisitedNodes;
    }

    public PMap getHints() {
        return this.hints;
    }

    private void assertNotNull(Object optionValue, String optionName) {
        if (optionValue == null) {
            throw new NullPointerException("Option '" + optionName + "' must NOT be null");
        }
    }

    public String toString() {
        return this.algorithm + ", " + this.weighting + ", " + (Object)((Object)this.traversalMode);
    }

    public static class Builder {
        private AlgorithmOptions opts = new AlgorithmOptions();
        private boolean buildCalled;

        public Builder traversalMode(TraversalMode traversalMode) {
            if (traversalMode == null) {
                throw new IllegalArgumentException("null as traversal mode is not allowed");
            }
            this.opts.traversalMode = traversalMode;
            return this;
        }

        public Builder weighting(Weighting weighting) {
            this.opts.weighting = weighting;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.opts.algorithm = algorithm;
            return this;
        }

        public Builder maxVisitedNodes(int maxVisitedNodes) {
            this.opts.maxVisitedNodes = maxVisitedNodes;
            return this;
        }

        public Builder hints(PMap hints) {
            this.opts.hints.put(hints);
            return this;
        }

        public AlgorithmOptions build() {
            if (this.buildCalled) {
                throw new IllegalStateException("Cannot call AlgorithmOptions.Builder.build() twice");
            }
            this.buildCalled = true;
            return this.opts;
        }
    }
}

