/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.Path4CH;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.storage.ShortcutUnpacker;
import com.graphhopper.util.EdgeIteratorState;

public class EdgeBasedPathCH
extends Path4CH {
    private final TurnWeighting turnWeighting;

    public EdgeBasedPathCH(Graph routingGraph, Graph baseGraph, Weighting weighting) {
        super(routingGraph, baseGraph, weighting);
        if (!(weighting instanceof TurnWeighting)) {
            throw new IllegalArgumentException("Need a TurnWeighting for edge-based CH");
        }
        this.turnWeighting = (TurnWeighting)weighting;
    }

    @Override
    protected ShortcutUnpacker getShortcutUnpacker(Graph routingGraph, Weighting weighting) {
        return new ShortcutUnpacker(routingGraph, new ShortcutUnpacker.Visitor(){

            @Override
            public void visit(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
                EdgeBasedPathCH.this.distance = EdgeBasedPathCH.this.distance + edge.getDistance();
                EdgeBasedPathCH.this.time = EdgeBasedPathCH.this.time + EdgeBasedPathCH.this.turnWeighting.calcMillis(edge, reverse, prevOrNextEdgeId);
                EdgeBasedPathCH.this.addEdge(edge.getEdge());
            }
        }, true);
    }

    @Override
    protected int getIncEdge(SPTEntry entry) {
        return ((CHEntry)entry).incEdge;
    }

    static /* synthetic */ double access$000(EdgeBasedPathCH x0) {
        return x0.distance;
    }

    static /* synthetic */ long access$300(EdgeBasedPathCH x0) {
        return x0.time;
    }
}

