/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.BikeFlagEncoder;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;

public class Bike2WeightFlagEncoder
extends BikeFlagEncoder {
    public Bike2WeightFlagEncoder() {
        this(new PMap());
    }

    public Bike2WeightFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    public Bike2WeightFlagEncoder(PMap properties) {
        super(properties);
        this.speedTwoDirections = true;
    }

    public Bike2WeightFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.speedTwoDirections = true;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    protected void handleSpeed(IntsRef edgeFlags, ReaderWay way, double speed) {
        this.speedEncoder.setDecimal(true, edgeFlags, speed);
        super.handleSpeed(edgeFlags, way, speed);
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        PointList pl = edge.fetchWayGeometry(3);
        if (!pl.is3D()) {
            throw new IllegalStateException("To support speed calculation based on elevation data it is necessary to enable import of it.");
        }
        IntsRef intsRef = edge.getFlags();
        if (!(way.hasTag("tunnel", (Object)"yes") || way.hasTag("bridge", (Object)"yes") || way.hasTag("highway", (Object)"steps"))) {
            double incEleSum = 0.0;
            double incDist2DSum = 0.0;
            double decEleSum = 0.0;
            double decDist2DSum = 0.0;
            double prevEle = pl.getElevation(0);
            double fullDist2D = edge.getDistance();
            if (Double.isInfinite(fullDist2D)) {
                throw new IllegalStateException("Infinite distance should not happen due to #435. way ID=" + way.getId());
            }
            if (fullDist2D < 1.0) {
                return;
            }
            double eleDelta = pl.getElevation(pl.size() - 1) - prevEle;
            if (eleDelta > 0.1) {
                incEleSum = eleDelta;
                incDist2DSum = fullDist2D;
            } else if (eleDelta < -0.1) {
                decEleSum = -eleDelta;
                decDist2DSum = fullDist2D;
            }
            double fwdIncline = incDist2DSum > 1.0 ? incEleSum / incDist2DSum : 0.0;
            double fwdDecline = decDist2DSum > 1.0 ? decEleSum / decDist2DSum : 0.0;
            double restDist2D = fullDist2D - incDist2DSum - decDist2DSum;
            double maxSpeed = this.getHighwaySpeed("cycleway");
            if (this.accessEnc.getBool(false, intsRef)) {
                double speed = this.getSpeed(false, intsRef);
                double fwdFaster = 1.0 + 2.0 * Helper.keepIn((double)fwdDecline, (double)0.0, (double)0.2);
                fwdFaster *= fwdFaster;
                double fwdSlower = 1.0 - 5.0 * Helper.keepIn((double)fwdIncline, (double)0.0, (double)0.2);
                fwdSlower *= fwdSlower;
                speed = speed * (fwdSlower * incDist2DSum + fwdFaster * decDist2DSum + 1.0 * restDist2D) / fullDist2D;
                this.setSpeed(false, intsRef, Helper.keepIn((double)speed, (double)2.0, (double)maxSpeed));
            }
            if (this.accessEnc.getBool(true, intsRef)) {
                double speedReverse = this.getSpeed(true, intsRef);
                double bwFaster = 1.0 + 2.0 * Helper.keepIn((double)fwdIncline, (double)0.0, (double)0.2);
                bwFaster *= bwFaster;
                double bwSlower = 1.0 - 5.0 * Helper.keepIn((double)fwdDecline, (double)0.0, (double)0.2);
                bwSlower *= bwSlower;
                speedReverse = speedReverse * (bwFaster * incDist2DSum + bwSlower * decDist2DSum + 1.0 * restDist2D) / fullDist2D;
                this.setSpeed(true, intsRef, Helper.keepIn((double)speedReverse, (double)2.0, (double)maxSpeed));
            }
        }
        edge.setFlags(intsRef);
    }

    @Override
    public String toString() {
        return "bike2";
    }
}

