/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.profiles.BooleanEncodedValue;
import com.graphhopper.routing.profiles.EncodedValue;
import com.graphhopper.routing.profiles.EncodedValueLookup;
import com.graphhopper.routing.profiles.Roundabout;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class OSMRoundaboutParser
implements TagParser {
    private final BooleanEncodedValue roundaboutEnc;

    public OSMRoundaboutParser() {
        this(Roundabout.create());
    }

    public OSMRoundaboutParser(BooleanEncodedValue roundaboutEnc) {
        this.roundaboutEnc = roundaboutEnc;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.roundaboutEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access, long relationFlags) {
        boolean isRoundabout;
        if (!access.isWay()) {
            return edgeFlags;
        }
        boolean bl = isRoundabout = way.hasTag("junction", (Object)"roundabout") || way.hasTag("junction", (Object)"circular");
        if (isRoundabout) {
            this.roundaboutEnc.setBool(false, edgeFlags, true);
        }
        return edgeFlags;
    }
}

